/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.properties.MutableGradleProperties;
import org.gradle.initialization.properties.ProjectPropertiesLoader;
import org.gradle.initialization.properties.SystemPropertiesInstaller;
import org.jspecify.annotations.Nullable;

public class DefaultGradlePropertiesController
implements GradlePropertiesController {
    private State state = new NotLoaded();
    private final GradleProperties sharedGradleProperties = new SharedGradleProperties();
    private final IGradlePropertiesLoader propertiesLoader;
    private final SystemPropertiesInstaller systemPropertiesInstaller;
    private final ProjectPropertiesLoader projectPropertiesLoader;

    public DefaultGradlePropertiesController(IGradlePropertiesLoader propertiesLoader, SystemPropertiesInstaller systemPropertiesInstaller, ProjectPropertiesLoader projectPropertiesLoader) {
        this.propertiesLoader = propertiesLoader;
        this.systemPropertiesInstaller = systemPropertiesInstaller;
        this.projectPropertiesLoader = projectPropertiesLoader;
    }

    @Override
    public GradleProperties getGradleProperties() {
        return this.sharedGradleProperties;
    }

    @Override
    public void loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
        this.state = this.state.loadGradlePropertiesFrom(settingsDir, setSystemProperties);
    }

    @Override
    public void unloadGradleProperties() {
        this.state = new NotLoaded();
    }

    public void overrideWith(GradleProperties gradleProperties) {
        this.state = this.state.overrideWith(gradleProperties);
    }

    private static interface State {
        public GradleProperties gradleProperties();

        public State loadGradlePropertiesFrom(File var1, boolean var2);

        public State overrideWith(GradleProperties var1);
    }

    private class NotLoaded
    implements State {
        private NotLoaded() {
        }

        @Override
        public GradleProperties gradleProperties() {
            throw new IllegalStateException("GradleProperties has not been loaded yet.");
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            MutableGradleProperties loadedProperties = DefaultGradlePropertiesController.this.propertiesLoader.loadGradleProperties(settingsDir);
            if (setSystemProperties) {
                DefaultGradlePropertiesController.this.systemPropertiesInstaller.setSystemPropertiesFrom(loadedProperties);
            }
            Map<String, String> projectProperties = DefaultGradlePropertiesController.this.projectPropertiesLoader.loadProjectProperties();
            loadedProperties.updateOverrideProperties(projectProperties);
            return new Loaded(loadedProperties, settingsDir);
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties) {
            return new Overridden(gradleProperties);
        }
    }

    private class SharedGradleProperties
    implements GradleProperties {
        private SharedGradleProperties() {
        }

        public @Nullable String find(String propertyName) {
            return this.gradleProperties().find(propertyName);
        }

        public Map<String, String> mergeProperties(Map<String, String> properties) {
            return this.gradleProperties().mergeProperties(properties);
        }

        public Map<String, String> getProperties() {
            return this.gradleProperties().getProperties();
        }

        private GradleProperties gradleProperties() {
            return DefaultGradlePropertiesController.this.state.gradleProperties();
        }
    }

    private static class Overridden
    implements State {
        private final GradleProperties gradleProperties;

        public Overridden(GradleProperties gradleProperties) {
            this.gradleProperties = gradleProperties;
        }

        @Override
        public GradleProperties gradleProperties() {
            return this.gradleProperties;
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            throw new IllegalStateException();
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties) {
            return new Overridden(gradleProperties);
        }
    }

    private static class Loaded
    implements State {
        private final GradleProperties gradleProperties;
        private final File propertiesDir;

        public Loaded(MutableGradleProperties gradleProperties, File propertiesDir) {
            this.gradleProperties = gradleProperties;
            this.propertiesDir = propertiesDir;
        }

        @Override
        public GradleProperties gradleProperties() {
            return this.gradleProperties;
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            if (!this.propertiesDir.equals(settingsDir)) {
                throw new IllegalStateException(String.format("GradleProperties has already been loaded from '%s' and cannot be loaded from '%s'.", this.propertiesDir, settingsDir));
            }
            return this;
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties) {
            throw new IllegalStateException("GradleProperties has already been loaded and cannot be overridden.");
        }
    }
}

