/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.DelegatingNamedDomainObjectSet;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;

public class DefaultRealizableTaskCollection<T extends Task>
extends DelegatingNamedDomainObjectSet<T>
implements TaskCollection<T>,
TaskDependencyContainer {
    private final Class<T> type;
    private final AtomicBoolean realized = new AtomicBoolean();
    private final MutableModelNode modelNode;
    private final Instantiator instantiator;

    public DefaultRealizableTaskCollection(Class<T> type, TaskCollection<T> delegate, MutableModelNode modelNode, Instantiator instantiator) {
        super(delegate);
        assert (!(delegate instanceof DefaultRealizableTaskCollection)) : "Attempt to wrap already realizable task collection in realizable wrapper: " + delegate;
        this.type = type;
        this.modelNode = modelNode;
        this.instantiator = instantiator;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        if (this.modelNode != null && this.realized.compareAndSet(false, true)) {
            this.modelNode.ensureAtLeast(ModelNode.State.SelfClosed);
            for (MutableModelNode node : this.modelNode.getLinks(ModelType.of(this.type))) {
                node.ensureAtLeast(ModelNode.State.GraphClosed);
            }
        }
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Task t = (Task)iterator.next();
            context.add((Object)t);
        }
    }

    @Override
    protected TaskCollection<T> getDelegate() {
        return (TaskCollection)super.getDelegate();
    }

    private <S extends T> TaskCollection<S> realizable(Class<S> type, TaskCollection<S> collection) {
        return (TaskCollection)Cast.uncheckedCast((Object)this.instantiator.newInstance(DefaultRealizableTaskCollection.class, new Object[]{type, collection, this.modelNode, this.instantiator}));
    }

    @Override
    public TaskCollection<T> named(Spec<String> nameFilter) {
        return this.realizable(this.type, this.getDelegate().named(nameFilter));
    }

    @Override
    public TaskCollection<T> matching(Spec<? super T> spec) {
        return this.realizable(this.type, this.getDelegate().matching(spec));
    }

    @Override
    public TaskCollection<T> matching(Closure closure) {
        return this.realizable(this.type, this.getDelegate().matching(closure));
    }

    @Override
    public <S extends T> TaskCollection<S> withType(Class<S> type) {
        return this.realizable(type, this.getDelegate().withType(type));
    }

    public Action<? super T> whenTaskAdded(Action<? super T> action) {
        return this.getDelegate().whenTaskAdded(action);
    }

    public void whenTaskAdded(Closure closure) {
        this.getDelegate().whenTaskAdded(closure);
    }

    @Override
    public TaskProvider<T> named(String name) throws InvalidUserDataException {
        return this.getDelegate().named(name);
    }

    @Override
    public TaskProvider<T> named(String name, Action<? super T> configurationAction) throws UnknownTaskException {
        return this.getDelegate().named(name, configurationAction);
    }

    @Override
    public <S extends T> TaskProvider<S> named(String name, Class<S> type) throws UnknownTaskException {
        return this.getDelegate().named(name, type);
    }

    @Override
    public <S extends T> TaskProvider<S> named(String name, Class<S> type, Action<? super S> configurationAction) throws UnknownTaskException {
        return this.getDelegate().named(name, type, configurationAction);
    }
}

