/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.cpp.internal;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.language.LibraryDependencies;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppLibrary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.internal.DefaultCppComponent;
import org.gradle.language.cpp.internal.DefaultCppSharedLibrary;
import org.gradle.language.cpp.internal.DefaultCppStaticLibrary;
import org.gradle.language.cpp.internal.MainLibraryVariant;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultLibraryDependencies;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public abstract class DefaultCppLibrary
extends DefaultCppComponent
implements CppLibrary,
PublicationAwareComponent {
    private final ConfigurableFileCollection publicHeaders;
    private final FileCollection publicHeadersWithConvention;
    private final SetProperty<Linkage> linkage;
    private final Property<CppBinary> developmentBinary = this.getObjectFactory().property(CppBinary.class);
    private final Configuration apiElements;
    private final MainLibraryVariant mainVariant;
    private final DefaultLibraryDependencies dependencies;

    @Inject
    public DefaultCppLibrary(String name, RoleBasedConfigurationContainerInternal configurations, AttributesFactory attributesFactory) {
        super(name);
        this.publicHeaders = this.getObjectFactory().fileCollection();
        this.publicHeadersWithConvention = this.createDirView(this.publicHeaders, "src/" + name + "/public");
        this.linkage = this.getObjectFactory().setProperty(Linkage.class);
        this.linkage.set(Collections.singleton(Linkage.SHARED));
        this.dependencies = (DefaultLibraryDependencies)this.getObjectFactory().newInstance(DefaultLibraryDependencies.class, new Object[]{this.getNames().withSuffix("implementation"), this.getNames().withSuffix("api")});
        Usage apiUsage = (Usage)this.getObjectFactory().named(Usage.class, "cplusplus-api");
        this.apiElements = configurations.consumableLocked(this.getNames().withSuffix("cppApiElements"), conf -> {
            conf.extendsFrom(new Configuration[]{this.dependencies.getApiDependencies()});
            conf.getAttributes().attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
            conf.getAttributes().attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        });
        AttributeContainerInternal publicationAttributes = attributesFactory.mutable();
        publicationAttributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)apiUsage);
        publicationAttributes.attribute(ArtifactTypeDefinition.ARTIFACT_TYPE_ATTRIBUTE, (Object)"zip");
        this.mainVariant = new MainLibraryVariant("api", this.apiElements, (AttributeContainer)publicationAttributes, this.getObjectFactory());
    }

    public DefaultCppSharedLibrary addSharedLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppSharedLibrary result = (DefaultCppSharedLibrary)this.getObjectFactory().newInstance(DefaultCppSharedLibrary.class, new Object[]{this.getNames().append(identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public DefaultCppStaticLibrary addStaticLibrary(NativeVariantIdentity identity, CppPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        DefaultCppStaticLibrary result = (DefaultCppStaticLibrary)this.getObjectFactory().newInstance(DefaultCppStaticLibrary.class, new Object[]{this.getNames().append(identity.getName()), this.getBaseName(), this.getCppSource(), this.getAllHeaderDirs(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity});
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"C++ library", (String)this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public Configuration getApiDependencies() {
        return this.dependencies.getApiDependencies();
    }

    @Override
    public LibraryDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super LibraryDependencies> action) {
        action.execute((Object)this.dependencies);
    }

    public Configuration getApiElements() {
        return this.apiElements;
    }

    @Override
    public MainLibraryVariant getMainPublication() {
        return this.mainVariant;
    }

    @Override
    public ConfigurableFileCollection getPublicHeaders() {
        return this.publicHeaders;
    }

    @Override
    public void publicHeaders(Action<? super ConfigurableFileCollection> action) {
        action.execute((Object)this.publicHeaders);
    }

    @Override
    public FileCollection getPublicHeaderDirs() {
        return this.publicHeadersWithConvention;
    }

    @Override
    public FileTree getPublicHeaderFiles() {
        PatternSet patterns = new PatternSet();
        patterns.include(new String[]{"**/*.h"});
        patterns.include(new String[]{"**/*.hpp"});
        patterns.include(new String[]{"**/*.h++"});
        patterns.include(new String[]{"**/*.hxx"});
        patterns.include(new String[]{"**/*.hm"});
        patterns.include(new String[]{"**/*.inl"});
        patterns.include(new String[]{"**/*.inc"});
        patterns.include(new String[]{"**/*.xsd"});
        return this.publicHeadersWithConvention.getAsFileTree().matching((PatternFilterable)patterns);
    }

    @Override
    public FileCollection getAllHeaderDirs() {
        return this.publicHeadersWithConvention.plus(super.getAllHeaderDirs());
    }

    public Property<CppBinary> getDevelopmentBinary() {
        return this.developmentBinary;
    }

    @Override
    public SetProperty<Linkage> getLinkage() {
        return this.linkage;
    }
}

