/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AttributeBasedFileVisitDetailsFactory;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.LocalFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.pattern.PatternStep;
import org.gradle.api.internal.file.pattern.PatternStepFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.nativeintegration.services.FileSystems;

public class SingleIncludePatternFileTree
implements MinimalFileTree,
LocalFileTree,
DirectoryTree {
    private final File baseDir;
    private final String includePattern;
    private final List<String> patternSegments;
    private final Spec<FileTreeElement> excludeSpec;
    private final FileSystem fileSystem = FileSystems.getDefault();

    public SingleIncludePatternFileTree(File baseDir, String includePattern) {
        this(baseDir, includePattern, (Spec<FileTreeElement>)Specs.satisfyNone());
    }

    public SingleIncludePatternFileTree(File baseDir, String includePattern, Spec<FileTreeElement> excludeSpec) {
        this.baseDir = baseDir;
        if (includePattern.endsWith("/") || includePattern.endsWith("\\")) {
            includePattern = includePattern + "**";
        }
        this.includePattern = includePattern;
        this.patternSegments = Arrays.asList(includePattern.split("[/\\\\]"));
        this.excludeSpec = excludeSpec;
    }

    public File getDir() {
        return this.baseDir;
    }

    public PatternSet getPatterns() {
        return new PatternSet().include(new String[]{this.includePattern}).exclude(this.excludeSpec);
    }

    @Override
    public void visitStructure(MinimalFileTree.MinimalFileTreeStructureVisitor visitor, FileTreeInternal owner) {
        visitor.visitFileTree(this.baseDir, this.getPatterns(), owner);
    }

    @Override
    public void visit(FileVisitor visitor) {
        this.doVisit(visitor, this.baseDir, new ArrayDeque<String>(), 0, new AtomicBoolean());
    }

    private void doVisit(FileVisitor visitor, File file, Deque<String> pathSegments, int segmentIndex, AtomicBoolean stopFlag) {
        if (stopFlag.get()) {
            return;
        }
        String segment = this.patternSegments.get(segmentIndex);
        if (segment.contains("**")) {
            PatternSet patternSet = new PatternSet();
            patternSet.include(new String[]{this.includePattern});
            patternSet.exclude(this.excludeSpec);
            DirectoryFileTree fileTree = new DirectoryFileTree(this.baseDir, patternSet, this.fileSystem);
            fileTree.visitFrom(visitor, file, new RelativePath(file.isFile(), pathSegments.toArray(new String[0])), stopFlag);
        } else if (segment.contains("*") || segment.contains("?")) {
            PatternStep step = PatternStepFactory.getStep((String)segment, (boolean)false);
            File[] children = file.listFiles();
            if (children == null) {
                if (!file.canRead()) {
                    throw new GradleException(String.format("Could not list contents of directory '%s' as it is not readable.", file));
                }
                throw new GradleException(String.format("Could not list contents of '%s'.", file));
            }
            for (File child : children) {
                if (!stopFlag.get()) {
                    String childName = child.getName();
                    if (!step.matches(childName)) continue;
                    pathSegments.addLast(childName);
                    this.doVisitDirOrFile(visitor, child, pathSegments, segmentIndex + 1, stopFlag);
                    pathSegments.removeLast();
                    continue;
                }
                break;
            }
        } else {
            pathSegments.addLast(segment);
            this.doVisitDirOrFile(visitor, new File(file, segment), pathSegments, segmentIndex + 1, stopFlag);
            pathSegments.removeLast();
        }
    }

    private void doVisitDirOrFile(FileVisitor visitor, File file, Deque<String> pathSegments, int segmentIndex, AtomicBoolean stopFlag) {
        if (file.isFile()) {
            if (segmentIndex == this.patternSegments.size()) {
                RelativePath path = new RelativePath(true, pathSegments.toArray(new String[0]));
                FileVisitDetails details = AttributeBasedFileVisitDetailsFactory.getRootFileVisitDetails(file.toPath(), path, stopFlag, this.fileSystem);
                if (!this.excludeSpec.isSatisfiedBy((Object)details)) {
                    visitor.visitFile(details);
                }
            }
        } else if (file.isDirectory()) {
            RelativePath path = new RelativePath(false, pathSegments.toArray(new String[0]));
            FileVisitDetails details = AttributeBasedFileVisitDetailsFactory.getRootFileVisitDetails(file.toPath(), path, stopFlag, this.fileSystem);
            if (!this.excludeSpec.isSatisfiedBy((Object)details)) {
                visitor.visitDir(details);
            }
            if (segmentIndex < this.patternSegments.size()) {
                this.doVisit(visitor, file, pathSegments, segmentIndex, stopFlag);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return "directory '" + this.baseDir + "' include '" + this.includePattern + "'";
    }
}

