/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.Factories;
import org.gradle.model.InvalidModelRuleException;
import org.gradle.model.ModelMap;
import org.gradle.model.ModelRuleBindingException;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.AbstractModelAction;
import org.gradle.model.internal.core.AddProjectionsAction;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DeferredModelAction;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMapGroovyView;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ModelElementProjection;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.report.IncompatibleTypeReferenceReporter;
import org.gradle.model.internal.type.ModelType;
import org.jspecify.annotations.Nullable;

public class NodeBackedModelMap<T>
extends ModelMapGroovyView<T>
implements ManagedInstance {
    private static final ElementFilter NO_PARENT = new ElementFilter(ModelType.UNTYPED){

        public boolean apply(MutableModelNode node) {
            return true;
        }

        public boolean isSatisfiedBy(ModelType<?> element) {
            return true;
        }

        @Override
        public void validateCanBindAction(MutableModelNode node, ModelAction action) {
        }

        @Override
        public void validateCanCreateElement(ModelPath path, ModelType<?> type) {
        }
    };
    private final ModelType<T> elementType;
    private final ModelRuleDescriptor sourceDescriptor;
    private final MutableModelNode modelNode;
    private final ModelViewState viewState;
    private final ChildNodeInitializerStrategy<? super T> creatorStrategy;
    private final ElementFilter elementFilter;
    private final ModelType<?> publicType;

    public NodeBackedModelMap(ModelType<?> publicType, ModelType<T> elementType, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, ModelViewState viewState, ChildNodeInitializerStrategy<? super T> creatorStrategy) {
        this(publicType, elementType, sourceDescriptor, modelNode, viewState, NO_PARENT, creatorStrategy);
    }

    private NodeBackedModelMap(ModelType<?> publicType, ModelType<T> elementType, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, ModelViewState viewState, ElementFilter parentFilter, ChildNodeInitializerStrategy<? super T> creatorStrategy) {
        this.publicType = publicType;
        this.viewState = viewState;
        this.creatorStrategy = creatorStrategy;
        this.elementType = elementType;
        this.modelNode = modelNode;
        this.sourceDescriptor = sourceDescriptor;
        this.elementFilter = parentFilter.withType(elementType);
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingRegistry(final NodeInitializerRegistry nodeInitializerRegistry) {
        return new ChildNodeInitializerStrategy<T>(){

            @Override
            public <S extends T> NodeInitializer initializer(ModelType<S> type, Spec<ModelType<?>> constraints) {
                return nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forExtensibleType(type, constraints));
            }
        };
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingParentNode(final ModelType<T> baseItemModelType) {
        return NodeBackedModelMap.createUsingParentNode(new Transformer<NamedEntityInstantiator<T>, MutableModelNode>(){

            public NamedEntityInstantiator<T> transform(MutableModelNode modelNode) {
                return (NamedEntityInstantiator)modelNode.getPrivateData(NodeBackedModelMap.instantiatorTypeOf(baseItemModelType));
            }
        });
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingParentNode(final Transformer<? extends NamedEntityInstantiator<T>, ? super MutableModelNode> instantiatorTransform) {
        return new ChildNodeInitializerStrategy<T>(){

            @Override
            public <S extends T> NodeInitializer initializer(final ModelType<S> type, Spec<ModelType<?>> constraints) {
                return new NodeInitializer(){

                    @Override
                    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
                        return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, AddProjectionsAction.of(subject, descriptor, UnmanagedModelProjection.of(type), new ModelElementProjection((ModelType<?>)type))).put((Object)ModelActionRole.Create, (Object)DirectNodeNoInputsModelAction.of(subject, descriptor, (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

                            public void execute(MutableModelNode modelNode) {
                                NamedEntityInstantiator instantiator = (NamedEntityInstantiator)instantiatorTransform.transform((Object)modelNode.getParent());
                                Object item = instantiator.create(modelNode.getPath().getName(), type.getConcreteClass());
                                modelNode.setPrivateData(type, item);
                            }
                        })).build();
                    }
                };
            }
        };
    }

    private static <I> ModelType<NamedEntityInstantiator<I>> instantiatorTypeOf(ModelType<I> type) {
        return new ModelType.Builder<NamedEntityInstantiator<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    @Override
    public String getName() {
        return this.modelNode.getPath().getName();
    }

    @Override
    public MutableModelNode getBackingNode() {
        return this.modelNode;
    }

    @Override
    public ModelType<?> getManagedType() {
        return ModelType.of(this.getClass());
    }

    private <E> void mutateChildren(ModelActionRole role, ModelType<E> filterType, String operation, Action<? super E> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = this.sourceDescriptor.append(operation);
        ModelReference<E> subject = ModelReference.of(filterType);
        this.modelNode.applyTo(NodePredicate.allLinks(this.elementFilter.withType(filterType)), role, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    private <E> void mutateChildren(ModelActionRole role, ModelType<E> filterType, DeferredModelAction configAction) {
        this.viewState.assertCanMutate();
        ModelReference<E> subject = ModelReference.of(filterType);
        this.modelNode.defineRulesFor(NodePredicate.allLinks(this.elementFilter.withType(filterType)), role, new DeferredActionWrapper<E>(subject, role, configAction));
    }

    @Override
    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.mutateChildren(ModelActionRole.Finalize, ModelType.of(type), "afterEach()", configAction);
    }

    public <S> void afterEach(Class<S> type, DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Finalize, ModelType.of(type), configAction);
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.mutateChildren(ModelActionRole.Finalize, this.elementType, "afterEach()", configAction);
    }

    public void afterEach(DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Finalize, this.elementType, configAction);
    }

    @Override
    public void all(Action<? super T> configAction) {
        this.mutateChildren(ModelActionRole.Mutate, this.elementType, "all()", configAction);
    }

    public void all(DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Initialize, this.elementType, configAction);
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.mutateChildren(ModelActionRole.Defaults, this.elementType, "beforeEach()", configAction);
    }

    public void beforeEach(DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Defaults, this.elementType, configAction);
    }

    @Override
    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.mutateChildren(ModelActionRole.Defaults, ModelType.of(type), "beforeEach()", configAction);
    }

    public <S> void beforeEach(Class<S> type, DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Defaults, ModelType.of(type), configAction);
    }

    @Override
    public boolean containsKey(Object name) {
        if (!(name instanceof String)) {
            this.viewState.assertCanReadChildren();
            return false;
        }
        this.viewState.assertCanReadChild((String)name);
        return this.modelNode.hasLink((String)name, this.elementFilter);
    }

    @Override
    public boolean containsValue(Object item) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void create(String name) {
        this.doCreate(name, this.elementType, (Action)null);
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    public void create(String name, DeferredModelAction configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.doCreate(name, ModelType.of(type), (Action)null);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    public <S extends T> void create(String name, Class<S> type, DeferredModelAction configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    @Override
    public void put(String name, T instance) {
        Class type = (Class)Cast.uncheckedCast(instance.getClass());
        ModelRuleDescriptor descriptor = this.sourceDescriptor.append("put()");
        if (instance instanceof ManagedInstance) {
            ManagedInstance target = (ManagedInstance)instance;
            this.modelNode.addReference(name, target.getManagedType(), target.getBackingNode(), descriptor);
        } else {
            this.modelNode.addLink(ModelRegistrations.unmanagedInstance(ModelReference.of(this.modelNode.getPath().child(name), type), Factories.constant(instance)).descriptor(descriptor).build());
        }
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, final DeferredModelAction action) {
        ModelPath childPath = this.modelNode.getPath().child(name);
        this.doCreate(childPath, type, action.getDescriptor(), DirectNodeNoInputsModelAction.of(ModelReference.of(childPath, type), action.getDescriptor(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode node) {
                action.execute(node, ModelActionRole.Initialize);
            }
        }));
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, @Nullable Action<? super S> initAction) {
        ModelPath childPath = this.modelNode.getPath().child(name);
        ModelRuleDescriptor descriptor = this.sourceDescriptor.append("create(%s)", name);
        if (initAction != null) {
            this.doCreate(childPath, type, descriptor, NoInputsModelAction.of(ModelReference.of(childPath, type), descriptor, initAction));
        } else {
            this.doCreate(childPath, type, descriptor, null);
        }
    }

    private <S extends T> void doCreate(ModelPath childPath, ModelType<S> type, ModelRuleDescriptor descriptor, @Nullable ModelAction initAction) {
        this.viewState.assertCanMutate();
        this.elementFilter.validateCanCreateElement(childPath, type);
        NodeInitializer nodeInitializer = this.creatorStrategy.initializer(type, this.elementFilter);
        ModelRegistrations.Builder builder = ModelRegistrations.of(childPath, nodeInitializer).descriptor(descriptor);
        if (initAction != null) {
            builder.action(ModelActionRole.Initialize, initAction);
        }
        ModelRegistration registration = builder.build();
        this.modelNode.addLink(registration);
    }

    @Override
    public @Nullable T get(Object name) {
        return this.get((String)name);
    }

    @Override
    public @Nullable T get(String name) {
        MutableModelNode link = this.modelNode.getLink(name);
        if (link == null) {
            return null;
        }
        this.viewState.assertCanReadChild(name);
        link.ensureUsable();
        if (!this.elementFilter.apply(link)) {
            return null;
        }
        if (this.viewState.isCanMutate()) {
            return link.asMutable(this.elementType, this.sourceDescriptor).getInstance();
        }
        return link.asImmutable(this.elementType, this.sourceDescriptor).getInstance();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        this.viewState.assertCanReadChildren();
        return ImmutableSet.copyOf(this.modelNode.getLinkNames(this.elementFilter));
    }

    @Override
    public int size() {
        this.viewState.assertCanReadChildren();
        return this.modelNode.getLinkCount(this.elementFilter);
    }

    @Override
    public void named(String name, Action<? super T> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = this.sourceDescriptor.append("named(%s)", name);
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.applyToLink(ModelActionRole.Mutate, new FilteringActionWrapper<T>(this.elementFilter, subject, NoInputsModelAction.of(subject, descriptor, configAction)));
    }

    @Override
    public void named(String name, Class<? extends RuleSource> ruleSource) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = this.sourceDescriptor.append("named(%s, %s)", name, ruleSource.getName());
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.defineRulesForLink(ModelActionRole.Defaults, new FilteringActionWrapper<T>(this.elementFilter, subject, DirectNodeNoInputsModelAction.of(subject, descriptor, new ApplyRuleSource(ruleSource))));
    }

    public void named(String name, DeferredModelAction action) {
        this.viewState.assertCanMutate();
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.applyToLink(ModelActionRole.Initialize, new FilteringActionWrapper<T>(this.elementFilter, subject, new DeferredActionWrapper<T>(subject, ModelActionRole.Mutate, action)));
    }

    @Override
    public String getDisplayName() {
        return this.publicType.getDisplayName() + " '" + this.modelNode.getPath() + "'";
    }

    @Override
    public Collection<T> values() {
        Iterable values = Iterables.transform(this.keySet(), (Function)new Function<String, T>(){

            public T apply(@Nullable String name) {
                return NodeBackedModelMap.this.get(name);
            }
        });
        return Lists.newArrayList((Iterable)values);
    }

    @Override
    public Iterator<T> iterator() {
        this.viewState.assertCanReadChildren();
        return Iterators.transform(this.keySet().iterator(), (Function)new Function<String, T>(){

            public T apply(@Nullable String name) {
                return NodeBackedModelMap.this.get(name);
            }
        });
    }

    @Override
    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        this.mutateChildren(ModelActionRole.Mutate, ModelType.of(type), "withType()", configAction);
    }

    public <S> void withType(Class<S> type, DeferredModelAction configAction) {
        this.mutateChildren(ModelActionRole.Mutate, ModelType.of(type), configAction);
    }

    @Override
    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        this.viewState.assertCanMutate();
        this.modelNode.applyTo(NodePredicate.allLinks(this.elementFilter.withType(type)), rules);
    }

    @Override
    public <S> ModelMap<S> withType(Class<S> typeClass) {
        ModelType type = ModelType.of(typeClass);
        return this.withType(type);
    }

    @Override
    public <S> ModelMap<S> withType(ModelType<S> type) {
        if (type.equals(this.elementType)) {
            return (ModelMap)Cast.uncheckedCast((Object)this);
        }
        ChildNodeInitializerStrategy creatorStrategy1 = (ChildNodeInitializerStrategy)Cast.uncheckedCast(this.creatorStrategy);
        return new NodeBackedModelMap<S>(this.publicType, type, this.sourceDescriptor, this.modelNode, this.viewState, this.elementFilter, creatorStrategy1);
    }

    @Override
    public Void methodMissing(String name, Object argsObj) {
        Object[] args = (Object[])argsObj;
        if (args.length == 2 && args[0] instanceof Class && args[1] instanceof DeferredModelAction) {
            Class itemType = (Class)Cast.uncheckedCast((Object)args[0]);
            DeferredModelAction action = (DeferredModelAction)Cast.uncheckedCast((Object)args[1]);
            this.doCreate(name, ModelType.of((Class)itemType), action);
            return null;
        }
        if (args.length == 1 && args[0] instanceof DeferredModelAction) {
            DeferredModelAction action = (DeferredModelAction)Cast.uncheckedCast((Object)args[0]);
            this.named(name, action);
            return null;
        }
        return super.methodMissing(name, argsObj);
    }

    private static abstract class ElementFilter
    implements Predicate<MutableModelNode>,
    Spec<ModelType<?>> {
        protected final ModelType<?> elementType;

        public ElementFilter(ModelType<?> elementType) {
            this.elementType = elementType;
        }

        public ElementFilter withType(Class<?> elementType) {
            return this.withType(ModelType.of(elementType));
        }

        public ElementFilter withType(ModelType<?> elementType) {
            if (this.elementType.equals(elementType)) {
                return this;
            }
            return new ChainedElementFilter(this, elementType);
        }

        public abstract void validateCanBindAction(MutableModelNode var1, ModelAction var2);

        public abstract void validateCanCreateElement(ModelPath var1, ModelType<?> var2);
    }

    private static class DeferredActionWrapper<T>
    extends AbstractModelAction<T> {
        private final ModelActionRole role;
        private final DeferredModelAction action;

        public DeferredActionWrapper(ModelReference<T> subject, ModelActionRole role, DeferredModelAction action) {
            super(subject, action.getDescriptor(), Collections.emptyList());
            this.role = role;
            this.action = action;
        }

        @Override
        public void execute(MutableModelNode node, List<ModelView<?>> inputs) {
            this.action.execute(node, this.role);
        }
    }

    private static class FilteringActionWrapper<T>
    extends AbstractModelAction<T> {
        private final ElementFilter elementFilter;
        private final ModelAction delegate;

        public FilteringActionWrapper(ElementFilter elementFilter, ModelReference<T> subject, ModelAction delegate) {
            super(subject, delegate.getDescriptor(), delegate.getInputs());
            this.elementFilter = elementFilter;
            this.delegate = delegate;
        }

        @Override
        public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
            this.elementFilter.validateCanBindAction(modelNode, this.delegate);
            this.delegate.execute(modelNode, inputs);
        }
    }

    private static class ApplyRuleSource
    implements Action<MutableModelNode> {
        private final ModelType<? extends RuleSource> rules;

        public ApplyRuleSource(Class<? extends RuleSource> rules) {
            this.rules = ModelType.of(rules);
        }

        public void execute(MutableModelNode node) {
            node.applyToSelf(this.rules.getConcreteClass());
        }
    }

    private static class ChainedElementFilter
    extends ElementFilter {
        private final ElementFilter parent;

        public ChainedElementFilter(ElementFilter parent, ModelType<?> elementType) {
            super(elementType);
            this.parent = parent;
        }

        public boolean isSatisfiedBy(ModelType<?> element) {
            return this.elementType.isAssignableFrom(element) && this.parent.isSatisfiedBy(element);
        }

        public boolean apply(MutableModelNode node) {
            node.ensureAtLeast(ModelNode.State.Discovered);
            return node.canBeViewedAs(this.elementType) && this.parent.apply(node);
        }

        @Override
        public void validateCanBindAction(MutableModelNode node, ModelAction action) {
            node.ensureAtLeast(ModelNode.State.Discovered);
            if (!node.canBeViewedAs(this.elementType)) {
                throw new InvalidModelRuleException(action.getDescriptor(), (Throwable)((Object)new ModelRuleBindingException(IncompatibleTypeReferenceReporter.of(node, this.elementType, action.getSubject().getDescription(), true).asString())));
            }
            this.parent.validateCanBindAction(node, action);
        }

        @Override
        public void validateCanCreateElement(ModelPath path, ModelType<?> type) {
            if (!this.elementType.isAssignableFrom(type)) {
                throw new IllegalArgumentException(String.format("Cannot create '%s' with type '%s' as this is not a subtype of '%s'.", path, type, this.elementType));
            }
            this.parent.validateCanCreateElement(path, type);
        }
    }
}

