/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.resolver;

import java.util.function.Predicate;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.transform.TransformStepNode;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public final class FilteringResolvedArtifactSet
implements ResolvedArtifactSet {
    private final ResolvedArtifactSet artifacts;
    private final Predicate<ResolvableArtifact> filter;

    public FilteringResolvedArtifactSet(ResolvedArtifactSet artifacts, Predicate<ResolvableArtifact> filter) {
        this.artifacts = artifacts;
        this.filter = filter;
    }

    @Override
    public void visit(ResolvedArtifactSet.Visitor visitor) {
        this.artifacts.visit(new FilteringVisitor(this.filter, visitor));
    }

    @Override
    public void visitTransformSources(ResolvedArtifactSet.TransformSourceVisitor visitor) {
        this.artifacts.visitTransformSources(new FilteringTransformSourceVisitor(this.filter, visitor));
    }

    @Override
    public void visitExternalArtifacts(Action<ResolvableArtifact> visitor) {
        this.artifacts.visitExternalArtifacts(new FilteringArtifactAction(this.filter, visitor));
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.artifacts.visitDependencies(context);
    }

    private static class FilteringVisitor
    implements ResolvedArtifactSet.Visitor {
        private final ResolvedArtifactSet.Visitor visitor;
        private final Predicate<ResolvableArtifact> filter;

        public FilteringVisitor(Predicate<ResolvableArtifact> filter, ResolvedArtifactSet.Visitor visitor) {
            this.visitor = visitor;
            this.filter = filter;
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            return this.visitor.prepareForVisit(source);
        }

        @Override
        public void visitArtifacts(ResolvedArtifactSet.Artifacts artifacts) {
            this.visitor.visitArtifacts(new FilteringArtifacts(this.filter, artifacts));
        }
    }

    private static class FilteringTransformSourceVisitor
    implements ResolvedArtifactSet.TransformSourceVisitor {
        private final ResolvedArtifactSet.TransformSourceVisitor visitor;
        private final Predicate<ResolvableArtifact> filter;

        public FilteringTransformSourceVisitor(Predicate<ResolvableArtifact> filter, ResolvedArtifactSet.TransformSourceVisitor visitor) {
            this.visitor = visitor;
            this.filter = filter;
        }

        @Override
        public void visitArtifact(ResolvableArtifact artifact) {
            if (this.filter.test(artifact)) {
                this.visitor.visitArtifact(artifact);
            }
        }

        @Override
        public void visitTransform(TransformStepNode source) {
            if (this.filter.test(source.getInputArtifact())) {
                this.visitor.visitTransform(source);
            }
        }
    }

    private static class FilteringArtifactAction
    implements Action<ResolvableArtifact> {
        private final Action<ResolvableArtifact> visitor;
        private final Predicate<ResolvableArtifact> filter;

        public FilteringArtifactAction(Predicate<ResolvableArtifact> filter, Action<ResolvableArtifact> visitor) {
            this.visitor = visitor;
            this.filter = filter;
        }

        public void execute(ResolvableArtifact artifact) {
            if (this.filter.test(artifact)) {
                this.visitor.execute((Object)artifact);
            }
        }
    }

    private static class FilteringArtifacts
    implements ResolvedArtifactSet.Artifacts {
        private final ResolvedArtifactSet.Artifacts artifacts;
        private final Predicate<ResolvableArtifact> filter;

        public FilteringArtifacts(Predicate<ResolvableArtifact> filter, ResolvedArtifactSet.Artifacts artifacts) {
            this.artifacts = artifacts;
            this.filter = filter;
        }

        @Override
        public void prepareForVisitingIfNotAlready() {
            this.artifacts.prepareForVisitingIfNotAlready();
        }

        @Override
        public void startFinalization(BuildOperationQueue<RunnableBuildOperation> actions, boolean requireFiles) {
            this.artifacts.startFinalization(actions, requireFiles);
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            this.artifacts.visit(new FilteringArtifactVisitor(this.filter, visitor));
        }
    }

    private static class FilteringArtifactVisitor
    implements ArtifactVisitor {
        private final ArtifactVisitor visitor;
        private final Predicate<ResolvableArtifact> filter;

        public FilteringArtifactVisitor(Predicate<ResolvableArtifact> filter, ArtifactVisitor visitor) {
            this.visitor = visitor;
            this.filter = filter;
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            return this.visitor.prepareForVisit(source);
        }

        @Override
        public void visitArtifact(DisplayName variantName, ImmutableAttributes variantAttributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
            if (this.filter.test(artifact)) {
                this.visitor.visitArtifact(variantName, variantAttributes, capabilities, artifact);
            }
        }

        @Override
        public boolean requireArtifactFiles() {
            return this.visitor.requireArtifactFiles();
        }

        @Override
        public void visitFailure(Throwable failure) {
            this.visitor.visitFailure(failure);
        }

        @Override
        public void endVisitCollection(FileCollectionInternal.Source source) {
            this.visitor.endVisitCollection(source);
        }
    }
}

