/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.changedetection.state.CachingFileHasher;
import org.gradle.api.internal.changedetection.state.FileTimeStampInspector;
import org.gradle.cache.scopes.GlobalScopedCacheBuilderFactory;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.UserHome.class})
public class GradleUserHomeScopeFileTimeStampInspector
extends FileTimeStampInspector
implements RootBuildLifecycleListener {
    private CachingFileHasher fileHasher;
    private final Object lock = new Object();
    private long currentTimestamp;
    private final Set<String> filesWithCurrentTimestamp = new HashSet<String>();
    private boolean isCurrentTimestampHighPrecision;

    public GradleUserHomeScopeFileTimeStampInspector(GlobalScopedCacheBuilderFactory cacheBuilderFactory) {
        super(cacheBuilderFactory.baseDirForCache("file-changes"));
    }

    public void attach(CachingFileHasher fileHasher) {
        this.fileHasher = fileHasher;
    }

    @Override
    public void afterStart() {
        this.updateOnStartBuild();
        this.currentTimestamp = this.currentTimestamp();
        this.isCurrentTimestampHighPrecision = GradleUserHomeScopeFileTimeStampInspector.isHighTimestampPrecision(this.currentTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean timestampCanBeUsedToDetectFileChange(String file, long timestamp) {
        if (!this.isReliableTimestampPrecision(timestamp)) {
            Object object = this.lock;
            synchronized (object) {
                if (timestamp == this.currentTimestamp) {
                    this.filesWithCurrentTimestamp.add(file);
                } else if (timestamp > this.currentTimestamp) {
                    this.filesWithCurrentTimestamp.clear();
                    this.filesWithCurrentTimestamp.add(file);
                    this.currentTimestamp = timestamp;
                }
            }
        }
        return super.timestampCanBeUsedToDetectFileChange(file, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeComplete() {
        this.updateOnFinishBuild();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.currentTimestamp == this.getLastBuildTimestamp()) {
                    for (String path : this.filesWithCurrentTimestamp) {
                        this.fileHasher.discard(path);
                    }
                }
            }
            finally {
                this.filesWithCurrentTimestamp.clear();
            }
        }
    }

    private boolean isReliableTimestampPrecision(long timestamp) {
        return this.isCurrentTimestampHighPrecision || GradleUserHomeScopeFileTimeStampInspector.isHighTimestampPrecision(timestamp);
    }

    private static boolean isHighTimestampPrecision(long fileTimestamp) {
        return fileTimestamp % 1000L != 0L;
    }
}

