/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import java.util.Arrays;
import org.gradle.api.NonNullApi;
import org.gradle.process.internal.health.memory.OsMemoryStatusAspect;

@NonNullApi
public class DefaultAvailableOsMemoryStatusAspect
implements OsMemoryStatusAspect.Available {
    private final String name;
    private final long total;
    private final long free;

    public DefaultAvailableOsMemoryStatusAspect(String name, long total, long free) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (total < 0L) {
            throw new IllegalArgumentException("total must be >= 0");
        }
        if (free < 0L) {
            throw new IllegalArgumentException("free must be >= 0");
        }
        this.name = name;
        this.total = total;
        this.free = free;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public long getFree() {
        return this.free;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAvailableOsMemoryStatusAspect that = (DefaultAvailableOsMemoryStatusAspect)o;
        return this.total == that.total && this.free == that.free && this.name.equals(that.name);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.total, this.free});
    }

    public String toString() {
        return "AvailableMemory[" + this.name + ", total=" + this.total + ", free=" + this.free + ']';
    }
}

