/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.UUIDGenerator;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.IncomingConnector;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;
import org.gradle.internal.remote.internal.inet.TcpIncomingConnector;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.Serializers;
import org.gradle.launcher.daemon.protocol.Message;
import org.gradle.launcher.daemon.server.DaemonServerConnector;
import org.gradle.launcher.daemon.server.IncomingConnectionHandler;
import org.gradle.launcher.daemon.server.SynchronizedDispatchConnection;

public class DaemonTcpServerConnector
implements DaemonServerConnector {
    private final IncomingConnector incomingConnector;
    private final Serializer<Message> serializer;
    private boolean started;
    private boolean stopped;
    private final Lock lifecycleLock = new ReentrantLock();
    private ConnectionAcceptor acceptor;

    public DaemonTcpServerConnector(ExecutorFactory executorFactory, InetAddressFactory inetAddressFactory, Serializer<Message> serializer) {
        this.serializer = serializer;
        this.incomingConnector = new TcpIncomingConnector(executorFactory, inetAddressFactory, (IdGenerator)new UUIDGenerator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address start(final IncomingConnectionHandler handler, final Runnable connectionErrorHandler) {
        this.lifecycleLock.lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException("server connector cannot be started as it is either stopping or has been stopped");
            }
            if (this.started) {
                throw new IllegalStateException("server connector cannot be started as it has already been started");
            }
            Action<ConnectCompletion> connectEvent = new Action<ConnectCompletion>(){

                public void execute(ConnectCompletion completion) {
                    RemoteConnection remoteConnection;
                    try {
                        remoteConnection = completion.create(Serializers.stateful((Serializer)DaemonTcpServerConnector.this.serializer));
                    }
                    catch (UncheckedIOException e) {
                        connectionErrorHandler.run();
                        throw e;
                    }
                    handler.handle(new SynchronizedDispatchConnection<Message>(remoteConnection));
                }
            };
            this.acceptor = this.incomingConnector.accept((Action)connectEvent, false);
            this.started = true;
            Address address = this.acceptor.getAddress();
            return address;
        }
        finally {
            this.lifecycleLock.unlock();
        }
    }

    @Override
    public void stop() {
        this.lifecycleLock.lock();
        try {
            this.stopped = true;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        CompositeStoppable.stoppable((Object[])new Object[]{this.acceptor, this.incomingConnector}).stop();
    }
}

