/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.lang.reflect.Modifier;
import org.gradle.api.NonNullApi;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.internal.reflect.Instantiator;

@NonNullApi
public class PluginInstantiator
implements Instantiator {
    private final Instantiator injectedInstantiator;
    private final Instantiator decoratedInstantiator;

    public PluginInstantiator(Instantiator injectionInstantiator, Instantiator decoratingInstantiator) {
        this.injectedInstantiator = injectionInstantiator;
        this.decoratedInstantiator = decoratingInstantiator;
    }

    public <T> T newInstance(Class<? extends T> type, Object ... parameters) throws ObjectInstantiationException {
        if (Modifier.isAbstract(type.getModifiers())) {
            return (T)this.decoratedInstantiator.newInstance(type, parameters);
        }
        return (T)this.injectedInstantiator.newInstance(type, parameters);
    }
}

