/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ComponentModuleMetadataHandlerInternal;
import org.gradle.api.internal.artifacts.ComponentSelectionRulesInternal;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.LegacyResolutionParameters;
import org.gradle.api.internal.artifacts.RepositoriesSupplier;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.dsl.ImmutableModuleReplacements;
import org.gradle.api.internal.artifacts.ivyservice.DefaultResolvedConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.ShortCircuitingResolutionExecutor;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.Conflict;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.DefaultVisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ResolutionResultGraphBuilder;
import org.gradle.api.internal.artifacts.repositories.ContentFilteringRepository;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.artifact.ImmutableArtifactTypeRegistry;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.util.Path;

public class DefaultConfigurationResolver
implements ConfigurationResolver {
    private final RepositoriesSupplier repositoriesSupplier;
    private final ShortCircuitingResolutionExecutor resolutionExecutor;
    private final AttributeDesugaring attributeDesugaring;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler;
    private final AttributeSchemaServices attributeSchemaServices;

    public DefaultConfigurationResolver(RepositoriesSupplier repositoriesSupplier, ShortCircuitingResolutionExecutor resolutionExecutor, AttributeDesugaring attributeDesugaring, ArtifactTypeRegistry artifactTypeRegistry, ComponentModuleMetadataHandlerInternal componentModuleMetadataHandler, AttributeSchemaServices attributeSchemaServices) {
        this.repositoriesSupplier = repositoriesSupplier;
        this.resolutionExecutor = resolutionExecutor;
        this.attributeDesugaring = attributeDesugaring;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.componentModuleMetadataHandler = componentModuleMetadataHandler;
        this.attributeSchemaServices = attributeSchemaServices;
    }

    @Override
    public ResolverResults resolveBuildDependencies(ConfigurationInternal configuration, CalculatedValue<ResolverResults> futureCompleteResults) {
        RootComponentMetadataBuilder.RootComponentState root = configuration.toRootComponent();
        VisitedGraphResults missingConfigurationResults = this.maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(configuration, root);
        if (missingConfigurationResults != null) {
            return DefaultResolverResults.buildDependenciesResolved(missingConfigurationResults, ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.buildDependenciesResolved(ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE));
        }
        ResolutionParameters params = this.getResolutionParameters(configuration, root, false);
        ConfigurationLegacyResolutionParameters legacyParams = new ConfigurationLegacyResolutionParameters(configuration.getResolutionStrategy());
        return this.resolutionExecutor.resolveBuildDependencies(legacyParams, params, futureCompleteResults);
    }

    @Override
    public ResolverResults resolveGraph(ConfigurationInternal configuration) {
        RootComponentMetadataBuilder.RootComponentState root = configuration.toRootComponent();
        VisitedGraphResults missingConfigurationResults = this.maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(configuration, root);
        if (missingConfigurationResults != null) {
            DefaultResolvedConfiguration resolvedConfiguration = new DefaultResolvedConfiguration(missingConfigurationResults, configuration.getResolutionHost(), ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, new ShortCircuitingResolutionExecutor.EmptyLenientConfiguration());
            return DefaultResolverResults.graphResolved(missingConfigurationResults, ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, DefaultResolverResults.DefaultLegacyResolverResults.graphResolved(ShortCircuitingResolutionExecutor.EmptyResults.INSTANCE, resolvedConfiguration));
        }
        ImmutableAttributes attributes = root.getRootVariant().getAttributes();
        List<ResolutionAwareRepository> filteredRepositories = ((List)this.repositoriesSupplier.get()).stream().filter(arg_0 -> DefaultConfigurationResolver.lambda$resolveGraph$0(configuration, (AttributeContainerInternal)attributes, arg_0)).collect(Collectors.toList());
        ResolutionParameters params = this.getResolutionParameters(configuration, root, true);
        ConfigurationLegacyResolutionParameters legacyParams = new ConfigurationLegacyResolutionParameters(configuration.getResolutionStrategy());
        return this.resolutionExecutor.resolveGraph(legacyParams, params, filteredRepositories);
    }

    @Override
    public List<ResolutionAwareRepository> getAllRepositories() {
        return (List)this.repositoriesSupplier.get();
    }

    private ResolutionParameters getResolutionParameters(ConfigurationInternal configuration, RootComponentMetadataBuilder.RootComponentState root, boolean includeConsistentResolutionLocks) {
        ResolutionStrategyInternal resolutionStrategy = configuration.getResolutionStrategy();
        ImmutableList<ResolutionParameters.ModuleVersionLock> moduleVersionLocks = includeConsistentResolutionLocks ? configuration.getConsistentResolutionVersionLocks() : ImmutableList.of();
        ImmutableArtifactTypeRegistry immutableArtifactTypeRegistry = this.attributeSchemaServices.getArtifactTypeRegistryFactory().create(this.artifactTypeRegistry);
        ImmutableModuleReplacements moduleReplacements = this.componentModuleMetadataHandler.getModuleReplacements();
        ConfigurationFailureResolutions failureResolutions = new ConfigurationFailureResolutions(configuration.getDomainObjectContext().getProjectIdentity(), configuration.getName());
        return new ResolutionParameters(configuration.getResolutionHost(), root.getRootComponent(), root.getRootVariant(), moduleVersionLocks, resolutionStrategy.getSortOrder(), configuration.getConfigurationIdentity(), immutableArtifactTypeRegistry, moduleReplacements, resolutionStrategy.getConflictResolution(), configuration.getName(), resolutionStrategy.isDependencyLockingEnabled(), resolutionStrategy.getIncludeAllSelectableVariantResults(), resolutionStrategy.isDependencyVerificationEnabled(), resolutionStrategy.isFailingOnDynamicVersions(), resolutionStrategy.isFailingOnChangingVersions(), failureResolutions, resolutionStrategy.getCachePolicy().asImmutable());
    }

    private static boolean shouldSkipRepository(ResolutionAwareRepository repository, String configurationName, AttributeContainer consumerAttributes) {
        if (!(repository instanceof ContentFilteringRepository)) {
            return false;
        }
        ContentFilteringRepository cfr = (ContentFilteringRepository)((Object)repository);
        Set<String> includedConfigurations = cfr.getIncludedConfigurations();
        Set<String> excludedConfigurations = cfr.getExcludedConfigurations();
        if (includedConfigurations != null && !includedConfigurations.contains(configurationName) || excludedConfigurations != null && excludedConfigurations.contains(configurationName)) {
            return true;
        }
        Map<Attribute<Object>, Set<Object>> requiredAttributes = cfr.getRequiredAttributes();
        return DefaultConfigurationResolver.hasNonRequiredAttribute(requiredAttributes, consumerAttributes);
    }

    private static boolean hasNonRequiredAttribute(@Nullable Map<Attribute<Object>, Set<Object>> requiredAttributes, AttributeContainer consumerAttributes) {
        if (requiredAttributes == null) {
            return false;
        }
        for (Map.Entry<Attribute<Object>, Set<Object>> entry : requiredAttributes.entrySet()) {
            Object value;
            Attribute<Object> key = entry.getKey();
            Set<Object> allowedValues = entry.getValue();
            if (allowedValues.contains(value = consumerAttributes.getAttribute(key))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VisitedGraphResults maybeGetEmptyGraphForInvalidMissingConfigurationWithNoDependencies(ConfigurationInternal configuration, RootComponentMetadataBuilder.RootComponentState root) {
        if (!root.hasRootVariant()) {
            configuration.runDependencyActions();
            if (configuration.getAllDependencies().isEmpty()) {
                ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Removing a configuration from the container before resolution").withAdvice("Do not remove configurations from the container and resolve them after.")).willBecomeAnErrorInGradle9().undocumented()).nagUser();
                LocalComponentGraphResolveState rootComponent = root.getRootComponent();
                MinimalResolutionResult emptyResult = ResolutionResultGraphBuilder.empty(rootComponent.getModuleVersionId(), rootComponent.getId(), configuration.getAttributes().asImmutable(), ImmutableCapabilities.of((Capability)rootComponent.getDefaultCapability()), configuration.getName(), this.attributeDesugaring);
                return new DefaultVisitedGraphResults(emptyResult, Collections.emptySet());
            }
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$resolveGraph$0(ConfigurationInternal configuration, AttributeContainerInternal attributes, ResolutionAwareRepository repository) {
        return !DefaultConfigurationResolver.shouldSkipRepository(repository, configuration.getName(), (AttributeContainer)attributes);
    }

    private static class ConfigurationLegacyResolutionParameters
    implements LegacyResolutionParameters {
        private final ResolutionStrategyInternal resolutionStrategy;

        public ConfigurationLegacyResolutionParameters(ResolutionStrategyInternal resolutionStrategy) {
            this.resolutionStrategy = resolutionStrategy;
        }

        @Override
        public ImmutableActionSet<DependencySubstitutionInternal> getDependencySubstitutionRules() {
            return this.resolutionStrategy.getDependencySubstitutionRule();
        }

        @Override
        public ImmutableList<CapabilitiesResolutionInternal.CapabilityResolutionRule> getCapabilityConflictResolutionRules() {
            return this.resolutionStrategy.getCapabilitiesResolutionRules().getRules();
        }

        @Override
        public ComponentSelectionRulesInternal getComponentSelectionRules() {
            return this.resolutionStrategy.getComponentSelection();
        }
    }

    private static class ConfigurationFailureResolutions
    implements ResolutionParameters.FailureResolutions {
        @Nullable
        private final ProjectIdentity owningProject;
        private final String configurationName;

        public ConfigurationFailureResolutions(@Nullable ProjectIdentity owningProject, String configurationName) {
            this.owningProject = owningProject;
            this.configurationName = configurationName;
        }

        @Override
        public List<String> forVersionConflict(Conflict conflict) {
            if (this.owningProject == null) {
                return Collections.emptyList();
            }
            String taskPath = this.owningProject.getBuildTreePath().append(Path.path((String)"dependencyInsight")).getPath();
            ModuleIdentifier moduleId = conflict.getModuleId();
            String dependencyNotation = moduleId.getGroup() + ":" + moduleId.getName();
            return Collections.singletonList(String.format("Run with %s --configuration %s --dependency %s to get more insight on how to solve the conflict.", taskPath, this.configurationName, dependencyNotation));
        }
    }
}

