/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.verification.verifier;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.verification.exceptions.InvalidGpgKeyIdsException;
import org.gradle.api.internal.artifacts.verification.model.IgnoredKey;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

@NonNullApi
public class DependencyVerificationConfiguration {
    private final boolean verifyMetadata;
    private final boolean verifySignatures;
    private final List<TrustedArtifact> trustedArtifacts;
    private final boolean useKeyServers;
    private final List<URI> keyServers;
    private final Set<IgnoredKey> ignoredKeys;
    private final List<TrustedKey> trustedKeys;
    private final KeyringFormat keyringFormat;

    public DependencyVerificationConfiguration(boolean verifyMetadata, boolean verifySignatures, List<TrustedArtifact> trustedArtifacts, boolean useKeyServers, List<URI> keyServers, Set<IgnoredKey> ignoredKeys, List<TrustedKey> trustedKeys, @Nullable KeyringFormat keyringFormat) {
        this.verifyMetadata = verifyMetadata;
        this.verifySignatures = verifySignatures;
        this.trustedArtifacts = ImmutableList.copyOf(trustedArtifacts);
        this.useKeyServers = useKeyServers;
        this.keyServers = keyServers;
        this.ignoredKeys = ignoredKeys;
        this.trustedKeys = trustedKeys;
        this.keyringFormat = keyringFormat;
    }

    @Nullable
    public KeyringFormat getKeyringFormat() {
        return this.keyringFormat;
    }

    public boolean isVerifySignatures() {
        return this.verifySignatures;
    }

    public boolean isVerifyMetadata() {
        return this.verifyMetadata;
    }

    public List<TrustedArtifact> getTrustedArtifacts() {
        return this.trustedArtifacts;
    }

    public List<URI> getKeyServers() {
        return this.keyServers;
    }

    public Set<IgnoredKey> getIgnoredKeys() {
        return this.ignoredKeys;
    }

    public List<TrustedKey> getTrustedKeys() {
        return this.trustedKeys;
    }

    public boolean isUseKeyServers() {
        return this.useKeyServers;
    }

    private static int compareNullableStrings(@Nullable String first, @Nullable String second) {
        if (first == null) {
            if (second == null) {
                return 0;
            }
            return -1;
        }
        if (second == null) {
            return 1;
        }
        return first.compareTo(second);
    }

    @NonNullApi
    public static enum KeyringFormat {
        ARMORED,
        BINARY;

    }

    public static class TrustedKey
    extends TrustCoordinates
    implements Comparable<TrustedKey> {
        private final String keyId;

        TrustedKey(String keyId, @Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex) {
            super(group, name, version, fileName, regex, null);
            if (keyId.getBytes(StandardCharsets.US_ASCII).length < 40) {
                throw new InvalidGpgKeyIdsException(Collections.singletonList(keyId));
            }
            this.keyId = keyId.toUpperCase(Locale.ROOT);
        }

        public String getKeyId() {
            return this.keyId;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TrustedKey that = (TrustedKey)o;
            return this.keyId.equals(that.keyId);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.keyId.hashCode();
            return result;
        }

        @Override
        public int compareTo(TrustedKey other) {
            int keyIdComparison = this.getKeyId().compareTo(other.getKeyId());
            if (keyIdComparison != 0) {
                return keyIdComparison;
            }
            return this.internalCompareTo(other);
        }
    }

    public static class TrustedArtifact
    extends TrustCoordinates
    implements Comparable<TrustedArtifact> {
        TrustedArtifact(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex, @Nullable String reason) {
            super(group, name, version, fileName, regex, reason);
        }

        @Override
        public int compareTo(TrustedArtifact other) {
            return this.internalCompareTo(other);
        }
    }

    public static abstract class TrustCoordinates {
        private final String group;
        private final String name;
        private final String version;
        private final String fileName;
        private final boolean regex;
        private final String reason;

        TrustCoordinates(@Nullable String group, @Nullable String name, @Nullable String version, @Nullable String fileName, boolean regex, @Nullable String reason) {
            this.group = group;
            this.name = name;
            this.version = version;
            this.fileName = fileName;
            this.regex = regex;
            this.reason = reason;
        }

        @Nullable
        public String getGroup() {
            return this.group;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getVersion() {
            return this.version;
        }

        @Nullable
        public String getFileName() {
            return this.fileName;
        }

        public boolean isRegex() {
            return this.regex;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }

        public boolean matches(ModuleComponentArtifactIdentifier id) {
            ModuleComponentIdentifier moduleComponentIdentifier = id.getComponentIdentifier();
            return this.matches(this.group, moduleComponentIdentifier.getGroup()) && this.matches(this.name, moduleComponentIdentifier.getModule()) && this.matches(this.version, moduleComponentIdentifier.getVersion()) && this.matches(this.fileName, id.getFileName());
        }

        private boolean matches(@Nullable String value, String expr) {
            if (value == null) {
                return true;
            }
            if (!this.regex) {
                return expr.equals(value);
            }
            return expr.matches(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrustCoordinates that = (TrustCoordinates)o;
            if (this.regex != that.regex) {
                return false;
            }
            if (!Objects.equals(this.group, that.group)) {
                return false;
            }
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.version, that.version)) {
                return false;
            }
            if (!Objects.equals(this.fileName, that.fileName)) {
                return false;
            }
            return Objects.equals(this.reason, that.reason);
        }

        public int hashCode() {
            int result = this.group != null ? this.group.hashCode() : 0;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
            result = 31 * result + (this.regex ? 1 : 0);
            result = 31 * result + (this.reason != null ? this.reason.hashCode() : 0);
            return result;
        }

        public int internalCompareTo(TrustCoordinates other) {
            int regexComparison = Boolean.compare(this.isRegex(), other.isRegex());
            if (regexComparison != 0) {
                return regexComparison;
            }
            int groupComparison = DependencyVerificationConfiguration.compareNullableStrings(this.getGroup(), other.getGroup());
            if (groupComparison != 0) {
                return groupComparison;
            }
            int nameComparison = DependencyVerificationConfiguration.compareNullableStrings(this.getName(), other.getName());
            if (nameComparison != 0) {
                return nameComparison;
            }
            int versionComparison = DependencyVerificationConfiguration.compareNullableStrings(this.getVersion(), other.getVersion());
            if (versionComparison != 0) {
                return versionComparison;
            }
            int fileNameComparison = DependencyVerificationConfiguration.compareNullableStrings(this.getFileName(), other.getFileName());
            if (fileNameComparison != 0) {
                return fileNameComparison;
            }
            return DependencyVerificationConfiguration.compareNullableStrings(this.getReason(), other.getReason());
        }
    }
}

