/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.publish;

import java.io.File;
import java.util.Date;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.PublishArtifactInternal;
import org.gradle.api.internal.artifacts.publish.AbstractPublishArtifact;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.util.internal.GUtil;

public class DecoratingPublishArtifact
extends AbstractPublishArtifact
implements ConfigurablePublishArtifact {
    private String name;
    private String extension;
    private String type;
    private String classifier;
    private final PublishArtifact publishArtifact;
    private boolean classifierSet;

    public DecoratingPublishArtifact(TaskDependencyFactory taskDependencyFactory, PublishArtifact publishArtifact) {
        super(taskDependencyFactory, publishArtifact.getBuildDependencies());
        this.publishArtifact = publishArtifact;
    }

    public PublishArtifact getPublishArtifact() {
        return this.publishArtifact;
    }

    @Override
    public DecoratingPublishArtifact builtBy(Object ... tasks) {
        super.builtBy(tasks);
        return this;
    }

    public String getName() {
        return (String)GUtil.getOrDefault((Object)this.name, () -> ((PublishArtifact)this.publishArtifact).getName());
    }

    public String getExtension() {
        return (String)GUtil.getOrDefault((Object)this.extension, () -> ((PublishArtifact)this.publishArtifact).getExtension());
    }

    public String getType() {
        return (String)GUtil.getOrDefault((Object)this.type, () -> ((PublishArtifact)this.publishArtifact).getType());
    }

    public String getClassifier() {
        if (this.classifierSet) {
            return this.classifier;
        }
        return this.publishArtifact.getClassifier();
    }

    public File getFile() {
        return this.publishArtifact.getFile();
    }

    public Date getDate() {
        return this.publishArtifact.getDate();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
        this.classifierSet = true;
    }

    public boolean shouldBePublished() {
        return PublishArtifactInternal.shouldBePublished((PublishArtifact)this.publishArtifact);
    }
}

