/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessorFactory;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheExpirationControl;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.FilteredModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentGraphSpecificResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentResolveState;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleResolution;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryFailureCollector;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.VersionedComponentChooser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.repositories.ArtifactResolutionDetails;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedByAttributesVersion;
import org.gradle.internal.resolve.RejectedByRuleVersion;
import org.gradle.internal.resolve.RejectedBySelectorVersion;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.caching.ComponentMetadataSupplierRuleExecutor;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.ComponentSelectionContext;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.ResourceAwareResolveResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicVersionResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicVersionResolver.class);
    private final List<ModuleComponentRepository<ExternalModuleComponentGraphResolveState>> repositories = new ArrayList<ModuleComponentRepository<ExternalModuleComponentGraphResolveState>>();
    private final List<String> repositoryNames = new ArrayList<String>();
    private final VersionedComponentChooser versionedComponentChooser;
    private final VersionParser versionParser;
    private final AttributesFactory attributesFactory;
    private final ComponentMetadataProcessorFactory componentMetadataProcessor;
    private final ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor;
    private final CacheExpirationControl cacheExpirationControl;

    public DynamicVersionResolver(VersionedComponentChooser versionedComponentChooser, VersionParser versionParser, AttributesFactory attributesFactory, ComponentMetadataProcessorFactory componentMetadataProcessor, ComponentMetadataSupplierRuleExecutor componentMetadataSupplierRuleExecutor, CacheExpirationControl cacheExpirationControl) {
        this.versionedComponentChooser = versionedComponentChooser;
        this.versionParser = versionParser;
        this.attributesFactory = attributesFactory;
        this.componentMetadataProcessor = componentMetadataProcessor;
        this.componentMetadataSupplierRuleExecutor = componentMetadataSupplierRuleExecutor;
        this.cacheExpirationControl = cacheExpirationControl;
    }

    public void add(ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository) {
        this.repositories.add(repository);
        this.repositoryNames.add(repository.getName());
    }

    public void resolve(ModuleComponentSelector requested, ComponentOverrideMetadata overrideMetadata, VersionSelector versionSelector, @Nullable VersionSelector rejectedVersionSelector, AttributeContainer consumerAttributes, BuildableComponentIdResolveResult result) {
        LOGGER.debug("Attempting to resolve version for {} using repositories {}", (Object)requested, this.repositoryNames);
        RepositoryFailureCollector errors = new RepositoryFailureCollector();
        ArrayList<RepositoryResolveState> resolveStates = new ArrayList<RepositoryResolveState>(this.repositories.size());
        for (ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository : this.repositories) {
            resolveStates.add(new RepositoryResolveState(this.versionedComponentChooser, requested, overrideMetadata, repository, versionSelector, rejectedVersionSelector, this.versionParser, consumerAttributes, this.attributesFactory, this.componentMetadataProcessor, this.componentMetadataSupplierRuleExecutor, this.cacheExpirationControl));
        }
        RepositoryChainModuleResolution latestResolved = this.findLatestModule(resolveStates, errors);
        if (latestResolved != null) {
            LOGGER.debug("Using {} from {}", (Object)latestResolved.component.getId(), latestResolved.repository);
            for (Throwable error : errors.getFailures()) {
                LOGGER.debug("Discarding resolve failure.", error);
            }
            this.found(result, resolveStates, latestResolved);
            return;
        }
        if (!errors.getFailures().isEmpty()) {
            result.failed(new ModuleVersionResolveException((ComponentSelector)requested, errors.getFailures()));
        } else {
            this.notFound(result, requested, resolveStates);
        }
    }

    private void found(BuildableComponentIdResolveResult result, List<RepositoryResolveState> resolveStates, RepositoryChainModuleResolution latestResolved) {
        for (RepositoryResolveState resolveState : resolveStates) {
            resolveState.registerAttempts(result);
        }
        result.resolved(latestResolved.component, new ModuleComponentGraphSpecificResolveState(latestResolved.repository.getName()));
    }

    private void notFound(BuildableComponentIdResolveResult result, ModuleComponentSelector requested, List<RepositoryResolveState> resolveStates) {
        for (RepositoryResolveState resolveState : resolveStates) {
            resolveState.applyTo(result);
        }
        if (result.isRejected()) {
            return;
        }
        result.failed(new ModuleVersionNotFoundException(requested, result.getAttempted(), result.getUnmatchedVersions(), result.getRejectedVersions()));
    }

    @Nullable
    private RepositoryChainModuleResolution findLatestModule(List<RepositoryResolveState> resolveStates, RepositoryFailureCollector failures) {
        LinkedList<RepositoryResolveState> queue = new LinkedList<RepositoryResolveState>(resolveStates);
        LinkedList<RepositoryResolveState> missing = new LinkedList<RepositoryResolveState>();
        RepositoryChainModuleResolution best = this.findLatestModule(queue, failures, missing);
        if (failures.hasFatalError()) {
            return null;
        }
        if (best != null) {
            return best;
        }
        queue.addAll(missing);
        missing.clear();
        return this.findLatestModule(queue, failures, missing);
    }

    @Nullable
    private RepositoryChainModuleResolution findLatestModule(LinkedList<RepositoryResolveState> queue, RepositoryFailureCollector failures, Collection<RepositoryResolveState> missing) {
        RepositoryChainModuleResolution best = null;
        block7: while (!queue.isEmpty()) {
            RepositoryResolveState request = queue.removeFirst();
            try {
                request.resolve();
            }
            catch (Exception t) {
                DynamicVersionResolver.handleFailure(queue, request, failures, t);
                continue;
            }
            switch (request.resolvedVersionMetadata.getState()) {
                case Failed: {
                    ModuleVersionResolveException failure = request.resolvedVersionMetadata.getFailure();
                    assert (failure != null);
                    DynamicVersionResolver.handleFailure(queue, request, failures, (Exception)((Object)failure));
                    continue block7;
                }
                case Missing: 
                case Unknown: {
                    if (!request.canMakeFurtherAttempts()) continue block7;
                    missing.add(request);
                    continue block7;
                }
                case Resolved: {
                    RepositoryChainModuleResolution moduleResolution = new RepositoryChainModuleResolution(request.repository, (ExternalModuleComponentGraphResolveState)request.resolvedVersionMetadata.getMetaData());
                    best = this.chooseBest(best, moduleResolution);
                    continue block7;
                }
            }
            throw new IllegalStateException("Unexpected state for resolution: " + (Object)((Object)request.resolvedVersionMetadata.getState()));
        }
        return best;
    }

    private static void handleFailure(List<RepositoryResolveState> queue, RepositoryResolveState request, RepositoryFailureCollector failures, Exception t) {
        failures.addFailure(t);
        if (request.isRepositoryDisabled() && !request.isContinueOnConnectionFailure()) {
            queue.clear();
            failures.markFatalError();
        }
    }

    @Nullable
    private RepositoryChainModuleResolution chooseBest(@Nullable RepositoryChainModuleResolution one, @Nullable RepositoryChainModuleResolution two) {
        if (one == null || two == null) {
            return two == null ? one : two;
        }
        return this.versionedComponentChooser.selectNewestComponent(one.component.getMetadata(), two.component.getMetadata()) == one.component.getMetadata() ? one : two;
    }

    private static class RepositoryResolveState
    implements ComponentSelectionContext {
        private final VersionedComponentChooser versionedComponentChooser;
        private final BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> resolvedVersionMetadata = new DefaultBuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState>();
        private final Map<String, CandidateResult> candidateComponents = new LinkedHashMap<String, CandidateResult>();
        private final Set<String> unmatchedVersions = new LinkedHashSet<String>();
        private final Set<RejectedVersion> rejectedVersions = new LinkedHashSet<RejectedVersion>();
        private final VersionListResult versionListingResult;
        private final ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository;
        private final AttemptCollector attemptCollector;
        private final ModuleComponentSelector selector;
        private final ComponentOverrideMetadata overrideMetadata;
        private final VersionSelector versionSelector;
        private final VersionSelector rejectedVersionSelector;
        private final VersionParser versionParser;
        private final ImmutableAttributes consumerAttributes;
        private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;
        private final AttributesFactory attributesFactory;
        private final ComponentMetadataSupplierRuleExecutor metadataSupplierRuleExecutor;
        private final CacheExpirationControl cacheExpirationControl;
        private ModuleComponentIdentifier firstRejected = null;

        public RepositoryResolveState(VersionedComponentChooser versionedComponentChooser, ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository, VersionSelector versionSelector, VersionSelector rejectedVersionSelector, VersionParser versionParser, AttributeContainer consumerAttributes, AttributesFactory attributesFactory, ComponentMetadataProcessorFactory componentMetadataProcessorFactory, ComponentMetadataSupplierRuleExecutor metadataSupplierRuleExecutor, CacheExpirationControl cacheExpirationControl) {
            this.versionedComponentChooser = versionedComponentChooser;
            this.overrideMetadata = overrideMetadata;
            this.selector = selector;
            this.versionSelector = versionSelector;
            this.rejectedVersionSelector = rejectedVersionSelector;
            this.repository = repository;
            this.versionParser = versionParser;
            this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
            this.attributesFactory = attributesFactory;
            this.metadataSupplierRuleExecutor = metadataSupplierRuleExecutor;
            this.cacheExpirationControl = cacheExpirationControl;
            this.attemptCollector = new AttemptCollector();
            this.consumerAttributes = this.buildAttributes(consumerAttributes, attributesFactory);
            this.versionListingResult = new VersionListResult(selector, overrideMetadata, repository);
        }

        private ImmutableAttributes buildAttributes(AttributeContainer consumerAttributes, AttributesFactory attributesFactory) {
            ImmutableAttributes immutableConsumerAttributes = ((AttributeContainerInternal)consumerAttributes).asImmutable();
            ImmutableAttributes dependencyAttributes = ((AttributeContainerInternal)this.selector.getAttributes()).asImmutable();
            return attributesFactory.concat(immutableConsumerAttributes, dependencyAttributes);
        }

        public boolean canMakeFurtherAttempts() {
            return this.versionListingResult.canMakeFurtherAttempts();
        }

        void resolve() {
            this.versionListingResult.resolve();
            switch (this.versionListingResult.result.getState()) {
                case Failed: {
                    this.resolvedVersionMetadata.failed(this.versionListingResult.result.getFailure());
                    break;
                }
                case Listed: {
                    this.selectMatchingVersionAndResolve();
                    break;
                }
                case Unknown: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state for version list result.");
                }
            }
        }

        private void selectMatchingVersionAndResolve() {
            this.versionedComponentChooser.selectNewestMatchingComponent(this.candidates(), this, this.versionSelector, this.rejectedVersionSelector, this.consumerAttributes);
        }

        @Override
        public void matches(ModuleComponentIdentifier moduleComponentIdentifier) {
            String version = moduleComponentIdentifier.getVersion();
            CandidateResult candidateResult = this.candidateComponents.get(version);
            candidateResult.tryResolveMetadata(this.resolvedVersionMetadata);
        }

        @Override
        public void failed(ModuleVersionResolveException failure) {
            this.resolvedVersionMetadata.failed(failure);
        }

        @Override
        public void noMatchFound() {
            this.resolvedVersionMetadata.missing();
        }

        @Override
        public void notMatched(ModuleComponentIdentifier id, VersionSelector requestedVersionMatcher) {
            this.unmatchedVersions.add(id.getVersion());
        }

        @Override
        public void rejectedByRule(RejectedByRuleVersion id) {
            this.rejectedVersions.add(id);
        }

        @Override
        public void doesNotMatchConsumerAttributes(RejectedByAttributesVersion rejectedVersion) {
            this.rejectedVersions.add(rejectedVersion);
        }

        @Override
        public Action<? super ArtifactResolutionDetails> getContentFilter() {
            if (this.repository instanceof FilteredModuleComponentRepository) {
                return ((FilteredModuleComponentRepository)this.repository).getFilterAction();
            }
            return null;
        }

        @Override
        public void rejectedBySelector(ModuleComponentIdentifier id, VersionSelector versionSelector) {
            if (this.firstRejected == null) {
                this.firstRejected = id;
            }
            this.rejectedVersions.add(new RejectedBySelectorVersion(id, versionSelector));
        }

        private List<CandidateResult> candidates() {
            ArrayList<CandidateResult> candidates = new ArrayList<CandidateResult>();
            for (String version : this.versionListingResult.result.getVersions()) {
                CandidateResult candidateResult = this.candidateComponents.get(version);
                if (candidateResult == null) {
                    candidateResult = new CandidateResult(this.selector, this.overrideMetadata, version, this.repository, this.attemptCollector, this.versionParser, this.componentMetadataProcessorFactory, this.attributesFactory, this.metadataSupplierRuleExecutor, this.cacheExpirationControl);
                    this.candidateComponents.put(version, candidateResult);
                }
                candidates.add(candidateResult);
            }
            return candidates;
        }

        protected void applyTo(BuildableComponentIdResolveResult target) {
            this.registerAttempts(target);
            if (this.firstRejected != null) {
                target.rejected((ComponentIdentifier)this.firstRejected, DefaultModuleVersionIdentifier.newId(this.firstRejected));
            }
        }

        private void registerAttempts(BuildableComponentIdResolveResult target) {
            this.versionListingResult.applyTo(target);
            this.attemptCollector.applyTo(target);
            target.unmatched(this.unmatchedVersions);
            target.rejections(this.rejectedVersions);
        }

        public boolean isContinueOnConnectionFailure() {
            return this.repository.isContinueOnConnectionFailure();
        }

        public boolean isRepositoryDisabled() {
            return this.repository.isRepositoryDisabled();
        }
    }

    private static class VersionListResult {
        private final DefaultBuildableModuleVersionListingResolveResult result = new DefaultBuildableModuleVersionListingResolveResult();
        private final ModuleComponentRepository<?> repository;
        private final ModuleComponentSelector selector;
        private final ComponentOverrideMetadata overrideMetadata;
        private boolean searchedLocally;
        private boolean searchedRemotely;

        public VersionListResult(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, ModuleComponentRepository<?> repository) {
            this.selector = selector;
            this.overrideMetadata = overrideMetadata;
            this.repository = repository;
        }

        void resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.selector, this.overrideMetadata, this.repository.getLocalAccess());
                if (this.result.hasResult()) {
                    if (this.result.isAuthoritative()) {
                        this.searchedRemotely = true;
                    }
                    return;
                }
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.selector, this.overrideMetadata, this.repository.getRemoteAccess());
            }
        }

        public boolean canMakeFurtherAttempts() {
            return !this.searchedRemotely;
        }

        public void applyTo(ResourceAwareResolveResult target) {
            this.result.applyTo(target);
        }

        private void process(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, ModuleComponentRepositoryAccess<?> moduleAccess) {
            moduleAccess.listModuleVersions(selector, overrideMetadata, this.result);
        }
    }

    private static class CandidateResult
    implements ModuleComponentResolveState {
        private final ModuleComponentIdentifier identifier;
        private final ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository;
        private final AttemptCollector attemptCollector;
        private final ComponentOverrideMetadata overrideMetadata;
        private final Version version;
        private final ComponentMetadataProcessorFactory componentMetadataProcessorFactory;
        private final AttributesFactory attributesFactory;
        private final ComponentMetadataSupplierRuleExecutor supplierRuleExecutor;
        private boolean searchedLocally;
        private boolean searchedRemotely;
        private final DefaultBuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result = new DefaultBuildableModuleComponentMetaDataResolveResult();
        private final CacheExpirationControl cacheExpirationControl;

        public CandidateResult(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, String version, ModuleComponentRepository<ExternalModuleComponentGraphResolveState> repository, AttemptCollector attemptCollector, VersionParser versionParser, ComponentMetadataProcessorFactory componentMetadataProcessorFactory, AttributesFactory attributesFactory, ComponentMetadataSupplierRuleExecutor supplierRuleExecutor, CacheExpirationControl cacheExpirationControl) {
            this.overrideMetadata = overrideMetadata;
            this.componentMetadataProcessorFactory = componentMetadataProcessorFactory;
            this.attributesFactory = attributesFactory;
            this.supplierRuleExecutor = supplierRuleExecutor;
            this.cacheExpirationControl = cacheExpirationControl;
            this.version = versionParser.transform(version);
            this.repository = repository;
            this.attemptCollector = attemptCollector;
            this.identifier = DefaultModuleComponentIdentifier.newId(selector.getModuleIdentifier(), version);
        }

        @Override
        public ModuleComponentIdentifier getId() {
            return this.identifier;
        }

        @Override
        public Version getVersion() {
            return this.version;
        }

        @Override
        public BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> resolve() {
            if (!this.searchedLocally) {
                this.searchedLocally = true;
                this.process(this.repository.getLocalAccess());
                if (this.result.hasResult() && this.result.isAuthoritative()) {
                    this.searchedRemotely = true;
                }
            }
            if (this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Resolved || this.result.getState() == BuildableModuleComponentMetaDataResolveResult.State.Failed) {
                return this.result;
            }
            if (!this.searchedRemotely) {
                this.searchedRemotely = true;
                this.process(this.repository.getRemoteAccess());
            }
            return this.result;
        }

        @Override
        public ComponentMetadataProcessorFactory getComponentMetadataProcessorFactory() {
            return this.componentMetadataProcessorFactory;
        }

        @Override
        public AttributesFactory getAttributesFactory() {
            return this.attributesFactory;
        }

        @Override
        public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
            return this.repository.getComponentMetadataSupplier();
        }

        @Override
        public ComponentMetadataSupplierRuleExecutor getComponentMetadataSupplierExecutor() {
            return this.supplierRuleExecutor;
        }

        @Override
        public CacheExpirationControl getCacheExpirationControl() {
            return this.cacheExpirationControl;
        }

        private void process(ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> access) {
            access.resolveComponentMetaData(this.identifier, this.overrideMetadata, this.result);
            this.attemptCollector.execute(this.result);
        }

        private void tryResolveMetadata(BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> target) {
            BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result = this.resolve();
            switch (result.getState()) {
                case Resolved: {
                    target.resolved(result.getMetaData());
                    return;
                }
                case Missing: {
                    result.applyTo(target);
                    target.missing();
                    return;
                }
                case Failed: {
                    target.failed(result.getFailure());
                    return;
                }
                case Unknown: {
                    return;
                }
            }
            throw new IllegalStateException();
        }
    }

    private static class AttemptCollector
    implements Action<ResourceAwareResolveResult> {
        private final List<String> attempts = new ArrayList<String>();

        private AttemptCollector() {
        }

        public void execute(ResourceAwareResolveResult resourceAwareResolveResult) {
            this.attempts.addAll(resourceAwareResolveResult.getAttempted());
        }

        public void applyTo(ResourceAwareResolveResult result) {
            for (String url : this.attempts) {
                result.attempted(url);
            }
        }
    }
}

