/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl;

import com.google.common.collect.ImmutableSet;
import java.io.Closeable;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.initialization.ClassLoaderScopeIdentifier;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;
import org.gradle.initialization.ClassLoaderScopeId;
import org.gradle.initialization.ClassLoaderScopeOrigin;
import org.gradle.initialization.ClassLoaderScopeRegistryListener;
import org.gradle.initialization.ClassLoaderScopeRegistryListenerManager;
import org.gradle.internal.buildtree.BuildTreeLifecycleListener;
import org.gradle.internal.cc.impl.serialize.ClassLoaderScopeSpec;
import org.gradle.internal.cc.impl.serialize.ClassLoadingKt;
import org.gradle.internal.cc.impl.serialize.DefaultClassEncoderKt;
import org.gradle.internal.cc.impl.serialize.ScopeLookup;
import org.gradle.internal.classloader.DelegatingClassLoader;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.graph.ClassLoaderRole;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServiceScope(value={Scope.BuildTree.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\"\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u00182\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J2\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\u0006\u0010-\u001a\u00020\u001aJ \u0010.\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00120\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/gradle/internal/cc/impl/ConfigurationCacheClassLoaderScopeRegistryListener;", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListener;", "Lorg/gradle/internal/cc/impl/serialize/ScopeLookup;", "Lorg/gradle/internal/buildtree/BuildTreeLifecycleListener;", "Ljava/io/Closeable;", "listenerManager", "Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;", "(Lorg/gradle/initialization/ClassLoaderScopeRegistryListenerManager;)V", "disposed", "", "knownClassLoaders", "", "Ljava/lang/ClassLoader;", "getKnownClassLoaders", "()Ljava/util/Set;", "loaders", "Ljava/util/IdentityHashMap;", "Lkotlin/Pair;", "Lorg/gradle/internal/cc/impl/serialize/ClassLoaderScopeSpec;", "Lorg/gradle/internal/serialize/graph/ClassLoaderRole;", "lock", "", "scopeSpecs", "", "Lorg/gradle/initialization/ClassLoaderScopeId;", "afterStart", "", "assertNotDisposed", "method", "", "childScopeCreated", "parentId", "childId", "origin", "Lorg/gradle/initialization/ClassLoaderScopeOrigin;", "classloaderCreated", "scopeId", "classLoaderId", "Lorg/gradle/api/internal/initialization/loadercache/ClassLoaderId;", "classLoader", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "implementationHash", "Lorg/gradle/internal/hash/HashCode;", "close", "dispose", "scopeFor", "configuration-cache"})
public final class ConfigurationCacheClassLoaderScopeRegistryListener
implements ClassLoaderScopeRegistryListener,
ScopeLookup,
BuildTreeLifecycleListener,
Closeable {
    @NotNull
    private final ClassLoaderScopeRegistryListenerManager listenerManager;
    @NotNull
    private final Object lock;
    @NotNull
    private final Map<ClassLoaderScopeId, ClassLoaderScopeSpec> scopeSpecs;
    @NotNull
    private final IdentityHashMap<ClassLoader, Pair<ClassLoaderScopeSpec, ClassLoaderRole>> loaders;
    private boolean disposed;

    public ConfigurationCacheClassLoaderScopeRegistryListener(@NotNull ClassLoaderScopeRegistryListenerManager listenerManager) {
        Intrinsics.checkNotNullParameter((Object)listenerManager, (String)"listenerManager");
        this.listenerManager = listenerManager;
        this.lock = new Object();
        this.scopeSpecs = new LinkedHashMap();
        this.loaders = new IdentityHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterStart() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotDisposed("afterStart");
            this.listenerManager.add((ClassLoaderScopeRegistryListener)this);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (this.disposed) {
                return;
            }
            this.scopeSpecs.clear();
            this.loaders.clear();
            this.listenerManager.remove((ClassLoaderScopeRegistryListener)this);
            this.disposed = true;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Pair<ClassLoaderScopeSpec, ClassLoaderRole> scopeFor(@Nullable ClassLoader classLoader) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotDisposed("scopeFor");
            Pair<ClassLoaderScopeSpec, ClassLoaderRole> pair = this.loaders.get(classLoader);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Set<ClassLoader> getKnownClassLoaders() {
        ImmutableSet immutableSet;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            ImmutableSet immutableSet2 = ImmutableSet.copyOf((Collection)this.loaders.keySet());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            immutableSet = immutableSet2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"synchronized(lock) {\n   \u2026f(loaders.keys)\n        }");
        return (Set)immutableSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void childScopeCreated(@NotNull ClassLoaderScopeId parentId, @NotNull ClassLoaderScopeId childId, @Nullable ClassLoaderScopeOrigin origin) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)childId, (String)"childId");
        Object object = this.lock;
        synchronized (object) {
            ClassLoaderScopeSpec classLoaderScopeSpec;
            boolean parentIsRoot;
            boolean bl = false;
            this.assertNotDisposed("childScopeCreated");
            if (this.scopeSpecs.containsKey(childId)) {
                return;
            }
            boolean bl2 = parentIsRoot = parentId.getParent() == null;
            if (parentIsRoot) {
                classLoaderScopeSpec = null;
            } else {
                ClassLoaderScopeSpec lookupParent = this.scopeSpecs.get(parentId);
                if (!(lookupParent != null)) {
                    boolean bl3 = false;
                    String string2 = "Cannot find parent " + parentId + " for child scope " + childId;
                    throw new IllegalArgumentException(string2.toString());
                }
                classLoaderScopeSpec = lookupParent;
            }
            ClassLoaderScopeSpec parent = classLoaderScopeSpec;
            String string3 = childId.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"childId.name");
            ClassLoaderScopeSpec child = new ClassLoaderScopeSpec(parent, string3, origin);
            this.scopeSpecs.put(childId, child);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classloaderCreated(@NotNull ClassLoaderScopeId scopeId, @NotNull ClassLoaderId classLoaderId, @NotNull ClassLoader classLoader, @NotNull ClassPath classPath, @Nullable HashCode implementationHash) {
        Intrinsics.checkNotNullParameter((Object)scopeId, (String)"scopeId");
        Intrinsics.checkNotNullParameter((Object)classLoaderId, (String)"classLoaderId");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        if (!(!(classLoader instanceof DelegatingClassLoader))) {
            boolean bl = false;
            String string2 = "Unexpected delegating " + ClassLoadingKt.describeClassLoader(classLoader) + " with id '" + classLoaderId + "' for scope '" + scopeId + "' with classpath '" + classPath + "'.\n" + DefaultClassEncoderKt.describeKnownClassLoaders(this) + "Please report this error, run './gradlew --stop' and try again.";
            throw new IllegalArgumentException(string2.toString());
        }
        Object object = this.lock;
        synchronized (object) {
            boolean local;
            boolean bl = false;
            this.assertNotDisposed("classloaderCreated");
            ClassLoaderScopeSpec spec = this.scopeSpecs.get(scopeId);
            if (!(spec != null)) {
                boolean bl2 = false;
                String string3 = "Spec for ClassLoaderScope '" + scopeId + "' not found!";
                throw new IllegalStateException(string3.toString());
            }
            boolean bl3 = local = scopeId instanceof ClassLoaderScopeIdentifier && Intrinsics.areEqual((Object)((ClassLoaderScopeIdentifier)scopeId).localId(), (Object)classLoaderId);
            if (local) {
                spec.setLocalClassPath(classPath);
                spec.setLocalImplementationHash(implementationHash);
            } else {
                spec.setExportClassPath(classPath);
            }
            ((Map)this.loaders).put(classLoader, new Pair((Object)spec, (Object)ClassLoaderRole.box-impl((boolean)ClassLoaderRole.constructor-impl((boolean)local))));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void assertNotDisposed(String method) {
        if (!(!this.disposed)) {
            boolean bl = false;
            String string2 = this.getClass().getSimpleName() + '.' + method + " cannot be used after being disposed of.";
            throw new IllegalStateException(string2.toString());
        }
    }
}

