/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.BulkFileListener;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import org.jetbrains.kotlin.com.intellij.util.ForcefulReparseModificationTracker;

public final class FileContentUtilCore {
    public static void reparseFiles(VirtualFile ... files2) {
        if (files2 == null) {
            FileContentUtilCore.$$$reportNull$$$0(0);
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files2));
    }

    public static void reparseFiles(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            FileContentUtilCore.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            HashSet<VFilePropertyChangeEvent> events = new HashSet<VFilePropertyChangeEvent>();
            for (VirtualFile file2 : files2) {
                if (file2 == null || file2.isDirectory() || !file2.isValid()) continue;
                events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", file2, "name", file2.getName(), file2.getName()));
            }
            BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            List eventList = Collections.unmodifiableList(new ArrayList(events));
            publisher.before(eventList);
            publisher.after(eventList);
            ForcefulReparseModificationTracker.increment();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/com/intellij/util/FileContentUtilCore", "reparseFiles"));
    }
}

