/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.internal.BiAction;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.NativeExecutableBinarySpec;
import org.gradle.nativeplatform.NativeLibrarySpec;
import org.gradle.nativeplatform.SharedLibraryBinarySpec;
import org.gradle.nativeplatform.StaticLibraryBinarySpec;
import org.gradle.nativeplatform.internal.NativeBinarySpecInternal;
import org.gradle.nativeplatform.internal.configure.NativeBinaryRules;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.platform.base.internal.BinaryNamingScheme;

public class NativeBinaries {
    public static void createNativeBinaries(NativeComponentSpec component, ModelMap<NativeBinarySpec> binaries, NativeDependencyResolver resolver, FileCollectionFactory fileCollectionFactory, BinaryNamingScheme namingScheme, NativePlatform platform, BuildType buildType, Flavor flavor) {
        if (component instanceof NativeLibrarySpec) {
            NativeBinaries.createNativeBinary(SharedLibraryBinarySpec.class, binaries, resolver, fileCollectionFactory, namingScheme.withBinaryType("SharedLibrary").withRole("shared", false), platform, buildType, flavor);
            NativeBinaries.createNativeBinary(StaticLibraryBinarySpec.class, binaries, resolver, fileCollectionFactory, namingScheme.withBinaryType("StaticLibrary").withRole("static", false), platform, buildType, flavor);
        } else {
            NativeBinaries.createNativeBinary(NativeExecutableBinarySpec.class, binaries, resolver, fileCollectionFactory, namingScheme.withBinaryType("Executable").withRole("executable", true), platform, buildType, flavor);
        }
    }

    private static <T extends NativeBinarySpec> void createNativeBinary(Class<T> type, ModelMap<NativeBinarySpec> binaries, final NativeDependencyResolver resolver, final FileCollectionFactory fileCollectionFactory, final BinaryNamingScheme namingScheme, final NativePlatform platform, final BuildType buildType, final Flavor flavor) {
        String name = namingScheme.getBinaryName();
        binaries.create(name, type);
        MutableModelNode backingNode = ((ManagedInstance)binaries).getBackingNode();
        ModelPath binaryPath = backingNode.getPath().child(name);
        backingNode.applyToLink(ModelActionRole.Defaults, DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of((ModelPath)binaryPath, NativeBinarySpec.class), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("initialize binary " + binaryPath), (BiAction)new BiAction<MutableModelNode, NativeBinarySpec>(){

            public void execute(MutableModelNode mutableModelNode, NativeBinarySpec nativeBinarySpec) {
                NativeBinaries.initialize(nativeBinarySpec, namingScheme, resolver, fileCollectionFactory, platform, buildType, flavor);
            }
        }));
        binaries.named(name, NativeBinaryRules.class);
    }

    public static void initialize(NativeBinarySpec nativeBinarySpec, BinaryNamingScheme namingScheme, NativeDependencyResolver resolver, FileCollectionFactory fileCollectionFactory, NativePlatform platform, BuildType buildType, Flavor flavor) {
        NativeBinarySpecInternal nativeBinary = (NativeBinarySpecInternal)nativeBinarySpec;
        nativeBinary.setNamingScheme(namingScheme);
        nativeBinary.setTargetPlatform(platform);
        nativeBinary.setBuildType(buildType);
        nativeBinary.setFlavor(flavor);
        nativeBinary.setResolver(resolver);
        nativeBinary.setFileCollectionFactory(fileCollectionFactory);
    }
}

