/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.internal.Try;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.instantiation.InstanceFactory;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.resolve.ModuleVersionResolveException;

public class DefaultDependencySubstitutionApplicator
implements DependencySubstitutionApplicator {
    private final InMemoryLoadingCache<SubstitutionCacheKey, Try<SubstitutionResult>> cache;

    public DefaultDependencySubstitutionApplicator(ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, Action<? super DependencySubstitutionInternal> rule, InstantiatorFactory instantiatorFactory, InMemoryCacheFactory cacheFactory) {
        InstanceFactory substitutionFactory = instantiatorFactory.decorateScheme().forType(DefaultDependencySubstitution.class);
        this.cache = cacheFactory.create(key -> Try.ofFailable(() -> DefaultDependencySubstitutionApplicator.executeSubstitutionRule((InstanceFactory<DefaultDependencySubstitution>)substitutionFactory, componentSelectionDescriptorFactory, key, rule)));
    }

    @Override
    public DependencyState applySubstitutions(DependencyMetadata metadata) {
        SubstitutionCacheKey key = new SubstitutionCacheKey(metadata.getSelector(), (ImmutableList<IvyArtifactName>)ImmutableList.copyOf(metadata.getArtifacts()));
        return (DependencyState)((Try)this.cache.get((Object)key)).map(result -> DefaultDependencySubstitutionApplicator.createDependencyStateFromSubstitution(metadata, result)).getOrMapFailure(failure -> DefaultDependencySubstitutionApplicator.createDependencyStateFromFailure(metadata, failure));
    }

    private static SubstitutionResult executeSubstitutionRule(InstanceFactory<DefaultDependencySubstitution> substitutionFactory, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, SubstitutionCacheKey requested, Action<? super DependencySubstitutionInternal> rule) {
        DependencySubstitutionInternal details = (DependencySubstitutionInternal)substitutionFactory.newInstance(new Object[]{componentSelectionDescriptorFactory, requested.target, requested.artifacts});
        rule.execute((Object)details);
        return SubstitutionResult.of(requested, details);
    }

    private static DependencyState createDependencyStateFromSubstitution(DependencyMetadata metadata, SubstitutionResult result) {
        ComponentSelector target = result.target;
        ImmutableList artifacts = result.artifacts;
        DependencyMetadata updatedMetadata = metadata;
        if (target != null || artifacts != null) {
            ComponentSelector actualTarget = target != null ? target : metadata.getSelector();
            updatedMetadata = artifacts == null ? metadata.withTarget(actualTarget) : metadata.withTargetAndArtifacts(actualTarget, (List<IvyArtifactName>)artifacts);
        }
        return new DependencyState(updatedMetadata, metadata.getSelector(), (ImmutableList<ComponentSelectionDescriptorInternal>)result.ruleDescriptors, null);
    }

    private static DependencyState createDependencyStateFromFailure(DependencyMetadata metadata, Throwable failure) {
        ModuleVersionResolveException resolveFailure = new ModuleVersionResolveException(metadata.getSelector(), failure);
        return new DependencyState(metadata, metadata.getSelector(), (ImmutableList<ComponentSelectionDescriptorInternal>)ImmutableList.of(), resolveFailure);
    }

    private static class SubstitutionCacheKey {
        private final ComponentSelector target;
        private final ImmutableList<IvyArtifactName> artifacts;
        private final int hashCode;

        public SubstitutionCacheKey(ComponentSelector target, ImmutableList<IvyArtifactName> artifacts) {
            this.target = target;
            this.artifacts = artifacts;
            this.hashCode = SubstitutionCacheKey.computeHashCode(artifacts, target);
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SubstitutionCacheKey that = (SubstitutionCacheKey)o;
            return this.target.equals(that.target) && this.artifacts.equals(that.artifacts);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int computeHashCode(List<IvyArtifactName> artifacts, ComponentSelector selector) {
            int result = selector.hashCode();
            result = 31 * result + artifacts.hashCode();
            return result;
        }
    }

    private static class SubstitutionResult {
        private static final SubstitutionResult NO_OP = new SubstitutionResult(null, null, (ImmutableList<ComponentSelectionDescriptorInternal>)ImmutableList.of());
        @Nullable
        private final ComponentSelector target;
        @Nullable
        private final ImmutableList<IvyArtifactName> artifacts;
        private final ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors;

        public SubstitutionResult(@Nullable ComponentSelector target, @Nullable ImmutableList<IvyArtifactName> artifacts, ImmutableList<ComponentSelectionDescriptorInternal> ruleDescriptors) {
            this.target = target;
            this.artifacts = artifacts;
            this.ruleDescriptors = ruleDescriptors;
        }

        public static SubstitutionResult of(SubstitutionCacheKey requested, DependencySubstitutionInternal details) {
            ComponentSelector target = details.getConfiguredTargetSelector();
            ImmutableList<DependencyArtifactSelector> artifacts = details.getConfiguredArtifactSelectors();
            if (target == null && artifacts == null) {
                return NO_OP;
            }
            ImmutableList<ComponentSelectionDescriptorInternal> descriptors = details.getRuleDescriptors();
            assert (descriptors != null && !descriptors.isEmpty());
            ImmutableList<IvyArtifactName> artifactNames = null;
            if (artifacts != null) {
                artifactNames = SubstitutionResult.toIvyArtifactNames(target, requested.target, artifacts);
            }
            return new SubstitutionResult(target, artifactNames, descriptors);
        }

        private static ImmutableList<IvyArtifactName> toIvyArtifactNames(@Nullable ComponentSelector configuredTarget, ComponentSelector requestedTarget, ImmutableList<DependencyArtifactSelector> artifacts) {
            if (artifacts.isEmpty()) {
                return ImmutableList.of();
            }
            ComponentSelector actualTarget = configuredTarget != null ? configuredTarget : requestedTarget;
            String targetModuleName = SubstitutionResult.getModuleName(actualTarget);
            ImmutableList.Builder artifactsBuilder = ImmutableList.builderWithExpectedSize((int)artifacts.size());
            for (DependencyArtifactSelector das : artifacts) {
                artifactsBuilder.add((Object)new DefaultIvyArtifactName(targetModuleName, das.getType(), das.getExtension() != null ? das.getExtension() : das.getType(), das.getClassifier()));
            }
            return artifactsBuilder.build();
        }

        private static String getModuleName(ComponentSelector target) {
            if (!(target instanceof ModuleComponentSelector)) {
                throw new IllegalStateException("Substitution with artifacts for something else than a module is not supported");
            }
            return ((ModuleComponentSelector)target).getModule();
        }
    }
}

