/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyArtifactSelector;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultArtifactSelectionDetails
implements ArtifactSelectionDetailsInternal {
    private final ImmutableList<IvyArtifactName> requestedArtifacts;
    @Nullable
    private List<DependencyArtifactSelector> targetSelectors;

    public DefaultArtifactSelectionDetails(ImmutableList<IvyArtifactName> requestedArtifacts) {
        this.requestedArtifacts = requestedArtifacts;
    }

    public boolean hasSelectors() {
        return !this.requestedArtifacts.isEmpty();
    }

    public List<DependencyArtifactSelector> getRequestedSelectors() {
        return Lists.transform(this.requestedArtifacts, artifact -> new DefaultDependencyArtifactSelector(artifact.getType(), artifact.getExtension(), artifact.getClassifier()));
    }

    public void withoutArtifactSelectors() {
        this.targetSelectors = new ArrayList<DependencyArtifactSelector>();
    }

    public void selectArtifact(String type, @Nullable String extension, @Nullable String classifier) {
        this.selectArtifact(new DefaultDependencyArtifactSelector(type, extension, classifier));
    }

    public void selectArtifact(DependencyArtifactSelector selector) {
        if (this.targetSelectors == null) {
            this.targetSelectors = new ArrayList<DependencyArtifactSelector>();
        }
        this.targetSelectors.add(selector);
    }

    @Override
    @Nullable
    public ImmutableList<DependencyArtifactSelector> getConfiguredSelectors() {
        return this.targetSelectors != null ? ImmutableList.copyOf(this.targetSelectors) : null;
    }
}

