/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.BasicJavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.ParentAwareTokenSet;
import org.jetbrains.kotlin.com.intellij.psi.tree.TokenSet;

public class WhiteSpaceAndCommentSetHolder {
    public static final WhiteSpaceAndCommentSetHolder INSTANCE = new WhiteSpaceAndCommentSetHolder();
    private static final ParentAwareTokenSet PRECEDING_COMMENT_SET = ParentAwareTokenSet.orSet(ParentAwareTokenSet.create(BasicJavaElementType.BASIC_MODULE), BasicElementTypes.BASIC_FULL_MEMBER_BIT_SET);
    private static final ParentAwareTokenSet TRAILING_COMMENT_SET = ParentAwareTokenSet.orSet(ParentAwareTokenSet.create(BasicJavaElementType.BASIC_PACKAGE_STATEMENT), BasicElementTypes.BASIC_IMPORT_STATEMENT_BASE_BIT_SET, BasicElementTypes.BASIC_FULL_MEMBER_BIT_SET, BasicElementTypes.BASIC_JAVA_STATEMENT_BIT_SET);
    private final WhitespacesAndCommentsBinder PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(false);
    private final WhitespacesAndCommentsBinder SPECIAL_PRECEDING_COMMENT_BINDER = new PrecedingWhitespacesAndCommentsBinder(true);
    private final WhitespacesAndCommentsBinder TRAILING_COMMENT_BINDER = new TrailingWhitespacesAndCommentsBinder();

    private WhiteSpaceAndCommentSetHolder() {
    }

    public WhitespacesAndCommentsBinder getPrecedingCommentBinder() {
        return this.PRECEDING_COMMENT_BINDER;
    }

    public WhitespacesAndCommentsBinder getSpecialPrecedingCommentBinder() {
        return this.SPECIAL_PRECEDING_COMMENT_BINDER;
    }

    public WhitespacesAndCommentsBinder getTrailingCommentBinder() {
        return this.TRAILING_COMMENT_BINDER;
    }

    public ParentAwareTokenSet getPrecedingCommentSet() {
        return PRECEDING_COMMENT_SET;
    }

    public ParentAwareTokenSet getTrailingCommentSet() {
        return TRAILING_COMMENT_SET;
    }

    private static class PrecedingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private final boolean myAfterEmptyImport;

        PrecedingWhitespacesAndCommentsBinder(boolean afterImport) {
            this.myAfterEmptyImport = afterImport;
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.isEmpty()) {
                return 0;
            }
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                if (!BasicJavaAstTreeUtil.is(tokens.get(idx), BasicJavaDocElementType.BASIC_DOC_COMMENT)) continue;
                return idx;
            }
            int result2 = tokens.size();
            for (int idx = tokens.size() - 1; idx >= 0; --idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (StringUtil.getLineBreakCount(getter2.get(idx)) <= 1) continue;
                    break;
                }
                if (!BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                if (!atStreamEdge && (idx != 0 || !this.myAfterEmptyImport) && (idx <= 0 || !TokenSet.WHITE_SPACE.contains(tokens.get(idx - 1)) || !StringUtil.containsLineBreak(getter2.get(idx - 1)))) continue;
                result2 = idx;
            }
            return result2;
        }
    }

    private static class TrailingWhitespacesAndCommentsBinder
    implements WhitespacesAndCommentsBinder {
        private TrailingWhitespacesAndCommentsBinder() {
        }

        @Override
        public int getEdgePosition(List<? extends IElementType> tokens, boolean atStreamEdge, WhitespacesAndCommentsBinder.TokenTextGetter getter2) {
            if (tokens.isEmpty()) {
                return 0;
            }
            int result2 = 0;
            for (int idx = 0; idx < tokens.size(); ++idx) {
                IElementType tokenType = tokens.get(idx);
                if (TokenSet.WHITE_SPACE.contains(tokenType)) {
                    if (!StringUtil.containsLineBreak(getter2.get(idx))) continue;
                    break;
                }
                if (!BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET.contains(tokenType)) break;
                result2 = idx + 1;
            }
            return result2;
        }
    }
}

