/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.util.internal.DeferredUtil;

@CacheableTask
public abstract class WriteProperties
extends DefaultTask {
    private final Map<String, Callable<String>> deferredProperties = new HashMap<String, Callable<String>>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private String lineSeparator = "\n";
    private String comment;
    private String encoding = "ISO_8859_1";

    @Input
    @ToBeReplacedByLazyProperty
    public Map<String, String> getProperties() {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.putAll(this.properties);
        try {
            for (Map.Entry<String, Callable<String>> e : this.deferredProperties.entrySet()) {
                propertiesBuilder.put((Object)e.getKey(), (Object)e.getValue().call());
            }
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return propertiesBuilder.build();
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties.clear();
        this.properties(properties);
    }

    public void property(final String name, final Object value) {
        WriteProperties.checkForNullValue(name, value);
        if (DeferredUtil.isDeferred((Object)value)) {
            this.deferredProperties.put(name, new Callable<String>(){

                @Override
                public String call() throws Exception {
                    Object futureValue = DeferredUtil.unpack((Object)value);
                    WriteProperties.checkForNullValue(name, futureValue);
                    return String.valueOf(futureValue);
                }
            });
        } else {
            this.properties.put(name, String.valueOf(value));
        }
    }

    public void properties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            this.property(e.getKey(), e.getValue());
        }
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getComment() {
        return this.comment;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Internal
    @Deprecated
    public File getOutputFile() {
        this.deprecationWarning();
        return (File)this.getDestinationFile().getAsFile().getOrNull();
    }

    private void deprecationWarning() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(WriteProperties.class, (String)"outputFile").replaceWith((Object)"destinationFile")).willBeRemovedInGradle9().withDslReference().nagUser();
    }

    @Deprecated
    public void setOutputFile(File outputFile) {
        this.deprecationWarning();
        this.getDestinationFile().set(outputFile);
    }

    @Deprecated
    public void setOutputFile(Object outputFile) {
        this.deprecationWarning();
        this.getDestinationFile().set(((FileOperations)this.getServices().get(FileOperations.class)).file(outputFile));
    }

    @OutputFile
    public abstract RegularFileProperty getDestinationFile();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void writeProperties() throws IOException {
        Charset charset = Charset.forName(this.getEncoding());
        File file = (File)this.getDestinationFile().getAsFile().get();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            Properties propertiesToWrite = new Properties();
            propertiesToWrite.putAll(this.getProperties());
            PropertiesUtils.store((Properties)propertiesToWrite, (OutputStream)out, (String)this.getComment(), (Charset)charset, (String)this.getLineSeparator());
        }
        finally {
            IoActions.closeQuietly((Closeable)out);
        }
    }

    private static void checkForNullValue(String key, Object value) {
        Preconditions.checkNotNull((Object)value, (String)"Property '%s' is not allowed to have a null value.", (Object)key);
    }
}

