/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.problems.failure;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.StackFramePredicate;
import org.gradle.internal.problems.failure.StackTraceRelevance;

class DefaultFailure
implements Failure {
    private final Throwable original;
    private final List<StackTraceElement> stackTrace;
    private final List<StackTraceRelevance> frameRelevance;
    private final List<Failure> suppressed;
    private final List<Failure> causes;

    public DefaultFailure(Throwable original, List<StackTraceElement> stackTrace, List<StackTraceRelevance> frameRelevance, List<Failure> suppressed, List<Failure> causes) {
        if (stackTrace.size() != frameRelevance.size()) {
            throw new IllegalArgumentException("stackTrace and frameRelevance must have the same size.");
        }
        this.original = original;
        this.stackTrace = ImmutableList.copyOf(stackTrace);
        this.frameRelevance = ImmutableList.copyOf(frameRelevance);
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.causes = ImmutableList.copyOf(causes);
    }

    public Class<? extends Throwable> getExceptionType() {
        return this.original.getClass();
    }

    public String getHeader() {
        return this.original.toString();
    }

    public List<StackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public StackTraceRelevance getStackTraceRelevance(int frameIndex) {
        return this.frameRelevance.get(frameIndex);
    }

    public List<Failure> getSuppressed() {
        return this.suppressed;
    }

    public List<Failure> getCauses() {
        return this.causes;
    }

    public int indexOfStackFrame(int fromIndex, StackFramePredicate predicate) {
        int size = this.stackTrace.size();
        for (int i = fromIndex; i < size; ++i) {
            if (!predicate.test(this.stackTrace.get(i), this.getStackTraceRelevance(i))) continue;
            return i;
        }
        return -1;
    }
}

