/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import com.google.common.base.Objects;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.IvyArtifactNameSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ComponentArtifactMetadataSerializer
extends AbstractSerializer<ComponentArtifactMetadata> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();

    public void write(Encoder encoder, ComponentArtifactMetadata value) throws Exception {
        if (!(value instanceof ModuleComponentArtifactMetadata)) {
            throw new IllegalArgumentException("Unknown artifact metadata type.");
        }
        ModuleComponentArtifactMetadata moduleComponentArtifactMetadata = (ModuleComponentArtifactMetadata)value;
        this.componentIdentifierSerializer.write(encoder, moduleComponentArtifactMetadata.getComponentId());
        IvyArtifactNameSerializer.INSTANCE.write(encoder, moduleComponentArtifactMetadata.getName());
    }

    public ComponentArtifactMetadata read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        IvyArtifactName name = IvyArtifactNameSerializer.INSTANCE.read(decoder);
        return new DefaultModuleComponentArtifactMetadata(componentIdentifier, name);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ComponentArtifactMetadataSerializer rhs = (ComponentArtifactMetadataSerializer)((Object)obj);
        return Objects.equal((Object)((Object)this.componentIdentifierSerializer), (Object)((Object)rhs.componentIdentifierSerializer));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.componentIdentifierSerializer});
    }
}

