/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.process.internal.health.memory.DefaultAvailableOsMemoryStatusAspect;
import org.gradle.process.internal.health.memory.DefaultUnavailableOsMemoryStatusAspect;
import org.gradle.process.internal.health.memory.OsMemoryStatus;
import org.gradle.process.internal.health.memory.OsMemoryStatusAspect;

public class OsMemoryStatusSnapshot
implements OsMemoryStatus {
    private final OsMemoryStatusAspect.Available physicalMemory;
    private final OsMemoryStatusAspect virtualMemory;

    public OsMemoryStatusSnapshot(long totalPhysicalMemory, long freePhysicalMemory) {
        this(new DefaultAvailableOsMemoryStatusAspect("physical", totalPhysicalMemory, freePhysicalMemory), new DefaultUnavailableOsMemoryStatusAspect("virtual"));
    }

    public OsMemoryStatusSnapshot(long totalPhysicalMemory, long freePhysicalMemory, long totalVirtualMemory, long freeVirtualMemory) {
        this(new DefaultAvailableOsMemoryStatusAspect("physical", totalPhysicalMemory, freePhysicalMemory), new DefaultAvailableOsMemoryStatusAspect("virtual", totalVirtualMemory, freeVirtualMemory));
    }

    private OsMemoryStatusSnapshot(OsMemoryStatusAspect.Available physicalMemory, OsMemoryStatusAspect virtualMemory) {
        this.physicalMemory = physicalMemory;
        this.virtualMemory = virtualMemory;
    }

    @Override
    public OsMemoryStatusAspect.Available getPhysicalMemory() {
        return this.physicalMemory;
    }

    @Override
    public OsMemoryStatusAspect getVirtualMemory() {
        return this.virtualMemory;
    }

    public String toString() {
        return "OS memory {" + this.physicalMemory + ", " + this.virtualMemory + '}';
    }
}

