/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import groovy.lang.Closure;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.internal.tasks.GroovydocParameters;
import org.gradle.api.plugins.internal.ant.AntWorkAction;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.api.tasks.javadoc.GroovydocAccess;
import org.gradle.util.internal.VersionNumber;

public abstract class GroovydocAntAction
extends AntWorkAction<GroovydocParameters> {
    protected String getActionName() {
        return "groovydoc";
    }

    protected Action<AntBuilderDelegate> getAntAction() {
        return new Action<AntBuilderDelegate>(){

            public void execute(final AntBuilderDelegate ant) {
                final GroovydocParameters parameters = (GroovydocParameters)GroovydocAntAction.this.getParameters();
                VersionNumber version = GroovydocAntAction.getGroovyVersion();
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                args.put("sourcepath", ((RegularFile)parameters.getTmpDir().get()).getAsFile());
                args.put("destdir", ((Directory)parameters.getDestinationDirectory().get()).getAsFile());
                args.put("use", parameters.getUse().get());
                if (GroovydocAntAction.isAtLeast(version, "2.4.6")) {
                    args.put("noTimestamp", parameters.getNoTimestamp().get());
                    args.put("noVersionStamp", parameters.getNoVersionStamp().get());
                }
                args.put(((GroovydocAccess)((Object)parameters.getAccess().get())).name().toLowerCase(Locale.ROOT), true);
                args.put("author", parameters.getIncludeAuthor().get());
                if (GroovydocAntAction.isAtLeast(version, "1.7.3")) {
                    args.put("processScripts", parameters.getProcessScripts().get());
                    args.put("includeMainForScripts", parameters.getIncludeMainForScripts().get());
                }
                GroovydocAntAction.putIfNotNull(args, "windowtitle", parameters.getWindowTitle().getOrNull());
                GroovydocAntAction.putIfNotNull(args, "doctitle", parameters.getDocTitle().getOrNull());
                GroovydocAntAction.putIfNotNull(args, "header", parameters.getHeader().getOrNull());
                GroovydocAntAction.putIfNotNull(args, "footer", parameters.getFooter().getOrNull());
                GroovydocAntAction.putIfNotNull(args, "overview", parameters.getOverview().getOrNull());
                ant.invokeMethod("taskdef", (Object)ImmutableMap.of((Object)"name", (Object)"groovydoc", (Object)"classname", (Object)"org.codehaus.groovy.ant.Groovydoc"));
                ant.invokeMethod("groovydoc", (Object)new Object[]{args, new Closure<Object>((Object)this, (Object)this){

                    public Object doCall(Object ignore) {
                        for (Groovydoc.Link link : (Set)parameters.getLinks().get()) {
                            ant.invokeMethod("link", (Object)new Object[]{ImmutableMap.of((Object)"packages", (Object)Joiner.on((String)",").join(link.getPackages()), (Object)"href", (Object)link.getUrl())});
                        }
                        return null;
                    }
                }});
            }
        };
    }

    private static VersionNumber getGroovyVersion() {
        try {
            Class<?> groovySystem = Thread.currentThread().getContextClassLoader().loadClass("groovy.lang.GroovySystem");
            Method getVersion = groovySystem.getDeclaredMethod("getVersion", new Class[0]);
            String versionString = (String)getVersion.invoke(null, new Object[0]);
            return VersionNumber.parse((String)versionString);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return VersionNumber.UNKNOWN;
        }
    }

    private static boolean isAtLeast(VersionNumber version, String versionString) {
        return version.compareTo(VersionNumber.parse((String)versionString)) >= 0;
    }

    private static void putIfNotNull(Map<String, Object> map, String key, @Nullable Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

