/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.Problem;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.logging.events.LogEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.process.internal.worker.DefaultWorkerLoggingProtocol;
import org.gradle.process.internal.worker.DefaultWorkerProblemProtocol;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.process.internal.worker.problem.WorkerProblemProtocol;
import org.gradle.process.internal.worker.request.ResponseProtocol;

@NonNullApi
public class Receiver
implements ResponseProtocol,
StreamCompletion,
StreamFailureHandler {
    private static final Object NULL = new Object();
    private static final Object END = new Object();
    private final BlockingQueue<Object> received = new ArrayBlockingQueue<Object>(10);
    private final String baseName;
    private Object next;
    private final WorkerLoggingProtocol loggingProtocol;
    private final WorkerProblemProtocol problemProtocol;

    public Receiver(String baseName, OutputEventListener outputEventListener) {
        this.loggingProtocol = new DefaultWorkerLoggingProtocol(outputEventListener);
        this.problemProtocol = new DefaultWorkerProblemProtocol();
        this.baseName = baseName;
    }

    public boolean awaitNextResult() {
        try {
            if (this.next == null) {
                this.next = this.received.take();
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        return this.next != END;
    }

    @Nullable
    public Object getNextResult() {
        this.awaitNextResult();
        Object next = this.next;
        if (next == END) {
            throw new IllegalStateException("No response received.");
        }
        this.next = null;
        if (next instanceof Failure) {
            Failure failure = (Failure)next;
            throw UncheckedException.throwAsUncheckedException((Throwable)failure.failure);
        }
        return next == NULL ? null : next;
    }

    public void handleStreamFailure(Throwable t) {
        this.failed(t);
    }

    public void endStream() {
        try {
            this.received.put(END);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void completed(@Nullable Object result) {
        try {
            this.received.put(result == null ? NULL : result);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void infrastructureFailed(Throwable failure) {
        this.failed((Throwable)((Object)WorkerProcessException.runFailed(this.baseName, failure)));
    }

    public void failed(Throwable failure) {
        try {
            this.received.put(new Failure(failure));
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public void reportProblem(Problem problem, OperationIdentifier id) {
        this.problemProtocol.reportProblem(problem, id);
    }

    public void sendOutputEvent(LogEvent event) {
        this.loggingProtocol.sendOutputEvent(event);
    }

    public void sendOutputEvent(StyledTextOutputEvent event) {
        this.loggingProtocol.sendOutputEvent(event);
    }

    static class Failure {
        final Throwable failure;

        public Failure(Throwable failure) {
            this.failure = failure;
        }
    }
}

