/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.resolver;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.VersionRef;

@ServiceScope(value={Scope.BuildTree.class})
public class VcsVersionSelectionCache {
    private final Map<String, File> resolvedVersions = new ConcurrentHashMap<String, File>();
    private final Map<String, Set<VersionRef>> repositoryVersions = new ConcurrentHashMap<String, Set<VersionRef>>();
    private final Map<String, File> checkoutDirs = new ConcurrentHashMap<String, File>();

    @Nullable
    public Set<VersionRef> getVersionsForRepo(VersionControlRepositoryConnection repository) {
        return this.repositoryVersions.get(repository.getUniqueId());
    }

    public void putVersionsForRepo(VersionControlRepositoryConnection repository, Set<VersionRef> versions) {
        this.repositoryVersions.put(repository.getUniqueId(), (Set<VersionRef>)ImmutableSet.copyOf(versions));
    }

    @Nullable
    public File getWorkingDirForRevision(VersionControlRepositoryConnection repository, VersionRef version) {
        String cacheKey = this.versionCacheKey(repository, version);
        return this.checkoutDirs.get(cacheKey);
    }

    public void putWorkingDirForRevision(VersionControlRepositoryConnection repository, VersionRef version, File dir) {
        String cacheKey = this.versionCacheKey(repository, version);
        this.checkoutDirs.put(cacheKey, dir);
    }

    @Nullable
    public File getWorkingDirForSelector(VersionControlRepositoryConnection repository, VersionConstraint constraint) {
        String cacheKey = this.constraintCacheKey(repository, constraint);
        return this.resolvedVersions.get(cacheKey);
    }

    public void putWorkingDirForSelector(VersionControlRepositoryConnection repository, VersionConstraint constraint, File workingDir) {
        String cacheKey = this.constraintCacheKey(repository, constraint);
        this.resolvedVersions.put(cacheKey, workingDir);
    }

    private String versionCacheKey(VersionControlRepositoryConnection repository, VersionRef version) {
        return repository.getUniqueId() + ":" + version.getCanonicalId();
    }

    private String constraintCacheKey(VersionControlRepositoryConnection repository, VersionConstraint constraint) {
        if (constraint.getBranch() != null) {
            return repository.getUniqueId() + ":b:" + constraint.getBranch();
        }
        return repository.getUniqueId() + ":v:" + constraint.getRequiredVersion();
    }
}

