/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.utils;

import com.google.common.collect.Interner;
import java.io.EOFException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.InstrumentationDependencyAnalysis;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HierarchicalNameSerializer;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.SetSerializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class DefaultInstrumentationAnalysisSerializer
implements InstrumentationAnalysisSerializer {
    private final StringInterner stringInterner;

    public DefaultInstrumentationAnalysisSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    @Override
    public void writeDependencyAnalysis(File output, InstrumentationDependencyAnalysis dependencyAnalysis) {
        try (KryoBackedEncoder encoder = new KryoBackedEncoder(Files.newOutputStream(output.toPath(), new OpenOption[0]));){
            DefaultInstrumentationAnalysisSerializer.writeMetadata(dependencyAnalysis.getMetadata(), encoder);
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            DefaultInstrumentationAnalysisSerializer.writeTypesMap(dependencyAnalysis.getDependencies(), (Encoder)encoder, nameSerializer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
        }
    }

    @Override
    public void writeTypeHierarchyAnalysis(File output, Map<String, Set<String>> types) {
        try (KryoBackedEncoder encoder = new KryoBackedEncoder(Files.newOutputStream(output.toPath(), new OpenOption[0]));){
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            DefaultInstrumentationAnalysisSerializer.writeTypesMap(types, (Encoder)encoder, nameSerializer);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
        }
    }

    private static void writeMetadata(InstrumentationArtifactMetadata metadata, KryoBackedEncoder encoder) {
        encoder.writeString((CharSequence)metadata.getArtifactName());
        encoder.writeString((CharSequence)metadata.getArtifactHash());
    }

    private static void writeTypesMap(Map<String, Set<String>> typesMap, Encoder encoder, HierarchicalNameSerializer nameSerializer) throws Exception {
        MapSerializer serializer = new MapSerializer((Serializer)nameSerializer, (Serializer)new SetSerializer((Serializer)nameSerializer));
        serializer.write(encoder, typesMap);
    }

    @Override
    public InstrumentationDependencyAnalysis readDependencyAnalysis(File output) {
        InstrumentationDependencyAnalysis instrumentationDependencyAnalysis;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(output.toPath(), new OpenOption[0]));
        try {
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            instrumentationDependencyAnalysis = new InstrumentationDependencyAnalysis(DefaultInstrumentationAnalysisSerializer.readMetadata(decoder), DefaultInstrumentationAnalysisSerializer.readTypesMap((Decoder)decoder, nameSerializer));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not serialize types map to a file: " + output, e);
            }
        }
        decoder.close();
        return instrumentationDependencyAnalysis;
    }

    @Override
    public InstrumentationArtifactMetadata readMetadataOnly(File input) {
        InstrumentationArtifactMetadata instrumentationArtifactMetadata;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(input.toPath(), new OpenOption[0]));
        try {
            instrumentationArtifactMetadata = DefaultInstrumentationAnalysisSerializer.readMetadata(decoder);
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not deserialize analysis from a file: " + input, e);
            }
        }
        decoder.close();
        return instrumentationArtifactMetadata;
    }

    @Override
    public Map<String, Set<String>> readTypeHierarchyAnalysis(File input) {
        Map<String, Set<String>> map;
        KryoBackedDecoder decoder = new KryoBackedDecoder(Files.newInputStream(input.toPath(), new OpenOption[0]));
        try {
            HierarchicalNameSerializer nameSerializer = new HierarchicalNameSerializer((Interner)this.stringInterner);
            map = DefaultInstrumentationAnalysisSerializer.readTypesMap((Decoder)decoder, nameSerializer);
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not deserialize analysis from a file: " + input, e);
            }
        }
        decoder.close();
        return map;
    }

    private static InstrumentationArtifactMetadata readMetadata(KryoBackedDecoder decoder) throws EOFException {
        return new InstrumentationArtifactMetadata(decoder.readString(), decoder.readString());
    }

    private static Map<String, Set<String>> readTypesMap(Decoder decoder, HierarchicalNameSerializer nameSerializer) throws Exception {
        MapSerializer serializer = new MapSerializer((Serializer)nameSerializer, (Serializer)new SetSerializer((Serializer)nameSerializer));
        return serializer.read(decoder);
    }
}

