/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.gradle.api.GradleScriptException;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.groovy.scripts.ScriptCompilationException;
import org.gradle.initialization.exception.ExceptionCollector;
import org.gradle.initialization.exception.InitializationException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.LocationAwareException;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.problems.Location;
import org.gradle.problems.buildtree.ProblemDiagnosticsFactory;

public class DefaultExceptionAnalyser
implements ExceptionCollector {
    private final ProblemDiagnosticsFactory diagnosticsFactory;

    public DefaultExceptionAnalyser(ProblemDiagnosticsFactory diagnosticsFactory) {
        this.diagnosticsFactory = diagnosticsFactory;
    }

    @Override
    public void collectFailures(Throwable exception, Collection<? super Throwable> failures) {
        if (exception instanceof ProjectConfigurationException) {
            ProjectConfigurationException projectConfigurationException = (ProjectConfigurationException)exception;
            ArrayList<Throwable> additionalFailures = new ArrayList<Throwable>();
            for (Throwable cause : projectConfigurationException.getCauses()) {
                if (cause instanceof GradleScriptException) {
                    failures.add(this.transform(cause));
                    continue;
                }
                additionalFailures.add(cause);
            }
            if (!additionalFailures.isEmpty()) {
                projectConfigurationException.initCauses(additionalFailures);
                failures.add(this.transform((Throwable)projectConfigurationException));
            }
        } else if (exception instanceof ServiceCreationException) {
            failures.add(this.transform((Throwable)((Object)new InitializationException(exception))));
        } else {
            failures.add(this.transform(exception));
        }
    }

    private Throwable transform(Throwable exception) {
        Throwable actualException = DefaultExceptionAnalyser.findDeepestRootException(exception);
        if (actualException instanceof LocationAwareException) {
            return actualException;
        }
        String source = null;
        Integer lineNumber = null;
        if (actualException instanceof ScriptCompilationException) {
            ScriptCompilationException scriptCompilationException = (ScriptCompilationException)((Object)actualException);
            source = scriptCompilationException.getScriptSource().getLongDisplayName().getCapitalizedDisplayName();
            lineNumber = scriptCompilationException.getLineNumber();
        }
        if (source == null) {
            for (Throwable currentException = actualException; currentException != null; currentException = currentException.getCause()) {
                Location location = this.diagnosticsFactory.forException(currentException).getLocation();
                if (location == null) continue;
                source = location.getSourceLongDisplayName().getCapitalizedDisplayName();
                lineNumber = location.getLineNumber();
            }
        }
        return new LocationAwareException(actualException, source, lineNumber);
    }

    private static Throwable findDeepestRootException(Throwable exception) {
        Throwable locationAware = null;
        Throwable result = null;
        Throwable contextMatch = null;
        Set dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        Throwable parent = null;
        for (Throwable current = exception; current != null; current = current.getCause()) {
            if (!dejaVu.add(current) && parent != null) {
                current = DefaultExceptionAnalyser.patchCircularCause(current, parent);
            }
            if (current instanceof LocationAwareException) {
                locationAware = current;
            } else if (current instanceof GradleScriptException || current instanceof TaskExecutionException) {
                result = current;
            } else if (contextMatch == null && current.getClass().getAnnotation(Contextual.class) != null) {
                contextMatch = current;
            }
            parent = current;
        }
        if (locationAware != null) {
            return locationAware;
        }
        if (result != null) {
            return result;
        }
        if (contextMatch != null) {
            return contextMatch;
        }
        return exception;
    }

    private static Throwable patchCircularCause(Throwable current, Throwable parent) {
        try {
            Field causeField = Throwable.class.getDeclaredField("cause");
            causeField.setAccessible(true);
            Throwable replacement = new Throwable("[CIRCULAR REFERENCE: " + current + "]");
            replacement.setStackTrace(current.getStackTrace());
            causeField.set(parent, replacement);
            return replacement;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return current;
        }
    }
}

