/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.logging.text.TreeFormatter;

public class UnionFileCollection
extends CompositeFileCollection {
    private final ImmutableSet<FileCollectionInternal> source;

    public UnionFileCollection(FileCollectionInternal ... source) {
        this.source = ImmutableSet.copyOf((Object[])source);
    }

    public UnionFileCollection(Iterable<? extends FileCollectionInternal> source) {
        this.source = ImmutableSet.copyOf(source);
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    protected void appendContents(TreeFormatter formatter) {
        formatter.node("source");
        formatter.startChildren();
        for (FileCollectionInternal files : this.source) {
            files.describeContents(formatter);
        }
        formatter.endChildren();
    }

    public Set<? extends FileCollection> getSources() {
        return this.source;
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        ImmutableSet.Builder newSource = ImmutableSet.builderWithExpectedSize((int)this.source.size());
        boolean hasChanges = false;
        for (FileCollectionInternal candidate : this.source) {
            FileCollectionInternal newCollection = candidate.replace(original, supplier);
            hasChanges |= newCollection != candidate;
            newSource.add((Object)newCollection);
        }
        if (hasChanges) {
            return new UnionFileCollection((Iterable<? extends FileCollectionInternal>)newSource.build());
        }
        return this;
    }

    @Override
    protected void visitChildren(Consumer<FileCollectionInternal> visitor) {
        for (FileCollectionInternal fileCollection : this.source) {
            visitor.accept(fileCollection);
        }
    }
}

