/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import org.gradle.api.GradleException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskExecutionOutcome;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkipOnlyIfTaskExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkipOnlyIfTaskExecuter.class);
    private final TaskExecuter executer;

    public SkipOnlyIfTaskExecuter(TaskExecuter executer) {
        this.executer = executer;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        SelfDescribingSpec<? super TaskInternal> unsatisfiedSpec;
        try {
            unsatisfiedSpec = task.getOnlyIf().findUnsatisfiedSpec(task);
        }
        catch (Throwable t) {
            state.setOutcome((RuntimeException)new GradleException(String.format("Could not evaluate onlyIf predicate for %s.", task), t));
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
        if (unsatisfiedSpec != null) {
            LOGGER.info("Skipping {} as task onlyIf '{}' is false.", (Object)task, (Object)unsatisfiedSpec.getDisplayName());
            state.setOutcome(TaskExecutionOutcome.SKIPPED);
            state.setSkipReasonMessage("'" + unsatisfiedSpec.getDisplayName() + "' not satisfied");
            return TaskExecuterResult.WITHOUT_OUTPUTS;
        }
        return this.executer.execute(task, state, context);
    }
}

