/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal.task;

import com.google.common.base.Strings;
import java.util.List;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.jvm.toolchain.internal.task.ReportableToolchain;

public class ToolchainReportRenderer
extends TextReportRenderer {
    private static final int INVALID_TOOLCHAIN_ERROR_CAUSE_LIMIT = 5;

    public void printToolchain(ReportableToolchain toolchain) {
        StyledTextOutput output = this.getTextOutput();
        JvmInstallationMetadata metadata = toolchain.metadata;
        String displayName = metadata.getDisplayName();
        output.withStyle(StyledTextOutput.Style.Identifier).println((Object)(" + " + displayName + " " + metadata.getRuntimeVersion()));
        this.printAttribute("Location", metadata.getJavaHome().toString());
        this.printAttribute("Language Version", metadata.getLanguageVersion().getMajorVersion());
        this.printAttribute("Vendor", metadata.getVendor().getDisplayName());
        this.printAttribute("Architecture", metadata.getArchitecture());
        this.printAttribute("Is JDK", String.valueOf(metadata.hasCapability(JvmInstallationMetadata.JavaInstallationCapability.JAVA_COMPILER)));
        this.printAttribute("Detected by", toolchain.location.getSource());
        output.println();
    }

    private void printAttribute(String key, String value) {
        String paddedKey = Strings.padEnd((String)(key + ":"), (int)20, (char)' ');
        this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("     | %s", new Object[]{paddedKey});
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)value);
    }

    public void printInvalidToolchains(List<ReportableToolchain> invalidToolchains) {
        if (!invalidToolchains.isEmpty()) {
            StyledTextOutput output = this.getTextOutput();
            output.withStyle(StyledTextOutput.Style.Identifier).println((Object)" + Invalid toolchains");
            for (ReportableToolchain toolchain : invalidToolchains) {
                JvmInstallationMetadata metadata = toolchain.metadata;
                output.withStyle(StyledTextOutput.Style.Identifier).println((Object)("     + " + metadata.getJavaHome()));
                this.printInvalidToolchainErrorLines(toolchain);
            }
            output.println();
        }
    }

    private void printInvalidToolchainErrorLines(ReportableToolchain invalidToolchain) {
        this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"Error:", (int)20, (char)' ')});
        this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)invalidToolchain.metadata.getErrorMessage());
        Throwable errorCause = invalidToolchain.metadata.getErrorCause();
        int reportedCauseLines = 0;
        for (Throwable cause = errorCause != null ? errorCause.getCause() : null; cause != null; cause = cause.getCause()) {
            this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"    Caused by:", (int)20, (char)' ')});
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)cause.getMessage());
            if (++reportedCauseLines != 5 || cause == null) continue;
            this.getTextOutput().withStyle(StyledTextOutput.Style.Normal).format("       | %s", new Object[]{Strings.padEnd((String)"", (int)20, (char)' ')});
            this.getTextOutput().withStyle(StyledTextOutput.Style.Description).println((Object)"...");
            break;
        }
    }
}

