/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0005\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0016\u0010\u0014\u001a\u00020\u0015*\u00020\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0017\"\u0016\u0010\u0018\u001a\u00020\u0015*\u00020\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0017\"\u0016\u0010\u0019\u001a\u00020\u0015*\u00020\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\"\u001a\u0010\u0019\u001a\u00020\u0015*\u0006\u0012\u0002\b\u00030\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001b\"\u0016\u0010\u001c\u001a\u00020\u0015*\u00020\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0017\"\u0016\u0010\u001d\u001a\u00020\u0015*\u00020\u00168\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0017\"\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u001b\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0005\"\u001f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u0001*\u0006\u0012\u0002\b\u00030%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&\u00a8\u0006'"}, d2={"anonymousInitializers", "", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getAnonymousInitializers", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/name/ClassId;", "delegateFields", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "getDelegateFields", "expandedConeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "getExpandedConeType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isFromLibrary", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isJava", "isJavaOrEnhancement", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isPrecompiled", "isSynthetic", "referredPropertySymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;", "getReferredPropertySymbol", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccess;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "superConeTypes", "getSuperConeTypes", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;)Ljava/util/List;", "tree"})
public final class FirDeclarationUtilKt {
    @Nullable
    public static final ConeClassLikeType getExpandedConeType(@NotNull FirTypeAlias $this$expandedConeType) {
        Intrinsics.checkNotNullParameter((Object)$this$expandedConeType, (String)"<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$expandedConeType.getExpandedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClassLikeDeclaration $this$classId) {
        ClassId classId;
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        FirClassLikeDeclaration firClassLikeDeclaration = $this$classId;
        if (firClassLikeDeclaration instanceof FirClass) {
            classId = ((FirClass)$this$classId).getSymbol().getClassId();
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            classId = ((FirTypeAlias)$this$classId).getSymbol().getClassId();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return classId;
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClass $this$classId) {
        Intrinsics.checkNotNullParameter((Object)$this$classId, (String)"<this>");
        return $this$classId.getSymbol().getClassId();
    }

    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClassSymbol<?> $this$superConeTypes) {
        List<ConeClassLikeType> list2;
        Intrinsics.checkNotNullParameter($this$superConeTypes, (String)"<this>");
        FirClassSymbol<?> firClassSymbol = $this$superConeTypes;
        if (firClassSymbol instanceof FirRegularClassSymbol) {
            list2 = FirDeclarationUtilKt.getSuperConeTypes((FirClass)((FirRegularClassSymbol)$this$superConeTypes).getFir());
        } else if (firClassSymbol instanceof FirAnonymousObjectSymbol) {
            list2 = FirDeclarationUtilKt.getSuperConeTypes((FirClass)((FirAnonymousObjectSymbol)$this$superConeTypes).getFir());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClass $this$superConeTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$superConeTypes, (String)"<this>");
        Iterable $this$mapNotNull$iv = $this$superConeTypes.getSuperTypeRefs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConeClassLikeType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = it;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnonymousInitializer> getAnonymousInitializers(@NotNull FirClass $this$anonymousInitializers) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$anonymousInitializers, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$anonymousInitializers.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirField> getDelegateFields(@NotNull FirClass $this$delegateFields) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$delegateFields, (String)"<this>");
        Iterable $this$filterIsInstance$iv = $this$delegateFields.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirField it = (FirField)element$iv$iv;
            boolean bl = false;
            FirDeclaration $this$isSynthetic$iv = it;
            boolean $i$f$isSynthetic = false;
            if (!Intrinsics.areEqual((Object)$this$isSynthetic$iv.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final FirPropertySymbol getReferredPropertySymbol(@NotNull FirQualifiedAccess $this$referredPropertySymbol) {
        Intrinsics.checkNotNullParameter((Object)$this$referredPropertySymbol, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol($this$referredPropertySymbol.getCalleeReference());
        return firBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firBasedSymbol : null;
    }

    public static final boolean isJava(@NotNull FirDeclaration $this$isJava) {
        Intrinsics.checkNotNullParameter((Object)$this$isJava, (String)"<this>");
        boolean $i$f$isJava = false;
        return Intrinsics.areEqual((Object)$this$isJava.getOrigin(), (Object)FirDeclarationOrigin.Java.INSTANCE);
    }

    public static final boolean isFromLibrary(@NotNull FirDeclaration $this$isFromLibrary) {
        Intrinsics.checkNotNullParameter((Object)$this$isFromLibrary, (String)"<this>");
        boolean $i$f$isFromLibrary = false;
        return Intrinsics.areEqual((Object)$this$isFromLibrary.getOrigin(), (Object)FirDeclarationOrigin.Library.INSTANCE);
    }

    public static final boolean isPrecompiled(@NotNull FirDeclaration $this$isPrecompiled) {
        Intrinsics.checkNotNullParameter((Object)$this$isPrecompiled, (String)"<this>");
        boolean $i$f$isPrecompiled = false;
        return Intrinsics.areEqual((Object)$this$isPrecompiled.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE);
    }

    public static final boolean isSynthetic(@NotNull FirDeclaration $this$isSynthetic) {
        Intrinsics.checkNotNullParameter((Object)$this$isSynthetic, (String)"<this>");
        boolean $i$f$isSynthetic = false;
        return Intrinsics.areEqual((Object)$this$isSynthetic.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.INSTANCE);
    }

    public static final boolean isJavaOrEnhancement(@NotNull FirDeclaration $this$isJavaOrEnhancement) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaOrEnhancement, (String)"<this>");
        boolean $i$f$isJavaOrEnhancement = false;
        return Intrinsics.areEqual((Object)$this$isJavaOrEnhancement.getOrigin(), (Object)FirDeclarationOrigin.Java.INSTANCE) || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE);
    }

    public static final boolean isJavaOrEnhancement(@NotNull FirBasedSymbol<?> $this$isJavaOrEnhancement) {
        Intrinsics.checkNotNullParameter($this$isJavaOrEnhancement, (String)"<this>");
        boolean $i$f$isJavaOrEnhancement = false;
        return Intrinsics.areEqual((Object)$this$isJavaOrEnhancement.getOrigin(), (Object)FirDeclarationOrigin.Java.INSTANCE) || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement.getOrigin(), (Object)FirDeclarationOrigin.Enhancement.INSTANCE);
    }
}

