/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.evaluate;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreter;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.checker.EvaluationMode;
import org.jetbrains.kotlin.ir.interpreter.checker.IrCompileTimeChecker;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001aH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/backend/evaluate/IrConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "interpreter", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;Lorg/jetbrains/kotlin/ir/declarations/IrFile;)V", "transformAnnotation", "", "annotation", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "transformAnnotations", "annotationContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "convertToConstIfPossible", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "replaceIfError", "original", "transformSingleArg", "expectedType", "transformVarArg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "fir2ir"})
public final class IrConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final IrInterpreter interpreter;
    @NotNull
    private final IrFile irFile;

    public IrConstTransformer(@NotNull IrInterpreter interpreter2, @NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.interpreter = interpreter2;
        this.irFile = irFile;
    }

    private final IrExpression replaceIfError(IrExpression $this$replaceIfError, IrExpression original) {
        return !($this$replaceIfError instanceof IrErrorExpression) ? $this$replaceIfError : original;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (((Boolean)expression2.accept(new IrCompileTimeChecker(null, EvaluationMode.ONLY_BUILTINS, 1, null), null)).booleanValue()) {
            return this.replaceIfError(this.interpreter.interpret(expression2, this.irFile), expression2);
        }
        return super.visitCall(expression2);
    }

    @Override
    @NotNull
    public IrStatement visitField(@NotNull IrField declaration) {
        boolean isConst;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        IrExpressionBody initializer2 = declaration.getInitializer();
        IrElementBase irElementBase = initializer2;
        if (irElementBase == null || (irElementBase = ((IrExpressionBody)irElementBase).getExpression()) == null) {
            return declaration;
        }
        IrElementBase expression2 = irElementBase;
        if (expression2 instanceof IrConst) {
            return declaration;
        }
        Object object = declaration.getCorrespondingPropertySymbol();
        boolean bl = object != null && (object = (IrProperty)object.getOwner()) != null ? ((IrProperty)object).isConst() : (isConst = false);
        if (isConst && ((Boolean)expression2.accept(new IrCompileTimeChecker(declaration, EvaluationMode.ONLY_BUILTINS), null)).booleanValue()) {
            initializer2.setExpression(this.replaceIfError(this.interpreter.interpret((IrExpression)expression2, this.irFile), (IrExpression)expression2));
        }
        return declaration;
    }

    @Override
    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.transformAnnotations(declaration);
        return super.visitDeclaration(declaration);
    }

    private final void transformAnnotations(IrAnnotationContainer annotationContainer) {
        Iterable $this$forEach$iv = annotationContainer.getAnnotations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructorCall annotation2 = (IrConstructorCall)element$iv;
            boolean bl = false;
            this.transformAnnotation(annotation2);
        }
    }

    private final void transformAnnotation(IrConstructorCall annotation2) {
        int n = annotation2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression arg;
            if (annotation2.getValueArgument(i) == null) continue;
            if (arg instanceof IrVararg) {
                annotation2.putValueArgument(i, this.transformVarArg((IrVararg)arg));
                continue;
            }
            annotation2.putValueArgument(i, this.transformSingleArg(arg, ((IrConstructor)annotation2.getSymbol().getOwner()).getValueParameters().get(i).getType()));
        }
    }

    private final IrVararg transformVarArg(IrVararg $this$transformVarArg) {
        if ($this$transformVarArg.getElements().isEmpty()) {
            return $this$transformVarArg;
        }
        IrVarargImpl newIrVararg = new IrVarargImpl($this$transformVarArg.getStartOffset(), $this$transformVarArg.getEndOffset(), $this$transformVarArg.getType(), $this$transformVarArg.getVarargElementType());
        for (IrVarargElement element : $this$transformVarArg.getElements()) {
            IrVarargElement irVarargElement = element;
            if (irVarargElement instanceof IrExpression) {
                IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg((IrExpression)element, $this$transformVarArg.getVarargElementType()));
                continue;
            }
            if (!(irVarargElement instanceof IrSpreadElement)) continue;
            IrExpression expression2 = ((IrSpreadElement)element).getExpression();
            if (expression2 instanceof IrVararg) {
                Iterable $this$forEach$iv = this.transformVarArg((IrVararg)expression2).getElements();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IrVarargElement it = (IrVarargElement)element$iv;
                    boolean bl = false;
                    IrExpressionsKt.addElement(newIrVararg, it);
                }
                continue;
            }
            IrExpressionsKt.addElement(newIrVararg, this.transformSingleArg(expression2, $this$transformVarArg.getVarargElementType()));
        }
        return newIrVararg;
    }

    private final IrExpression transformSingleArg(IrExpression $this$transformSingleArg, IrType expectedType) {
        if (((Boolean)$this$transformSingleArg.accept(new IrCompileTimeChecker(null, EvaluationMode.ONLY_BUILTINS, 1, null), null)).booleanValue()) {
            IrExpression irExpression = this.replaceIfError(this.interpreter.interpret($this$transformSingleArg, this.irFile), $this$transformSingleArg);
            return this.convertToConstIfPossible(irExpression, expectedType);
        }
        if ($this$transformSingleArg instanceof IrConstructorCall) {
            this.transformAnnotation((IrConstructorCall)$this$transformSingleArg);
        }
        return $this$transformSingleArg;
    }

    private final IrExpression convertToConstIfPossible(IrExpression $this$convertToConstIfPossible, IrType type2) {
        IrExpression irExpression;
        if (!($this$convertToConstIfPossible instanceof IrConst) || type2 instanceof IrErrorType) {
            irExpression = $this$convertToConstIfPossible;
        } else if (IrTypePredicatesKt.isArray(type2)) {
            Intrinsics.checkNotNull((Object)type2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            IrType irType = IrTypesKt.getTypeOrNull((IrTypeArgument)CollectionsKt.single(((IrSimpleType)type2).getArguments()));
            Intrinsics.checkNotNull((Object)irType);
            irExpression = this.convertToConstIfPossible($this$convertToConstIfPossible, irType);
        } else {
            irExpression = IrTypeUtilsKt.isPrimitiveArray(type2) ? this.convertToConstIfPossible($this$convertToConstIfPossible, $this$convertToConstIfPossible.getType()) : (IrExpression)IrTreeBuildUtilsKt.toIrConst(((IrConst)$this$convertToConstIfPossible).getValue(), type2, $this$convertToConstIfPossible.getStartOffset(), $this$convertToConstIfPossible.getEndOffset());
        }
        return irExpression;
    }
}

