/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.jvm.toolchain.JavaCompiler;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.JavadocTool;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainUsageProgressDetails;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainQueryService;

public class DefaultJavaToolchainService
implements JavaToolchainService {
    private final JavaToolchainQueryService queryService;
    private final ObjectFactory objectFactory;

    @Inject
    public DefaultJavaToolchainService(JavaToolchainQueryService queryService, ObjectFactory objectFactory) {
        this.queryService = queryService;
        this.objectFactory = objectFactory;
    }

    @Override
    public Provider<JavaCompiler> compilerFor(Action<? super JavaToolchainSpec> config) {
        return this.compilerFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavaCompiler> compilerFor(JavaToolchainSpec spec) {
        return this.queryService.toolFor(spec, JavaToolchain::getJavaCompiler, DefaultJavaToolchainUsageProgressDetails.JavaTool.COMPILER);
    }

    @Override
    public Provider<JavaLauncher> launcherFor(Action<? super JavaToolchainSpec> config) {
        return this.launcherFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavaLauncher> launcherFor(JavaToolchainSpec spec) {
        return this.queryService.toolFor(spec, JavaToolchain::getJavaLauncher, DefaultJavaToolchainUsageProgressDetails.JavaTool.LAUNCHER);
    }

    @Override
    public Provider<JavadocTool> javadocToolFor(Action<? super JavaToolchainSpec> config) {
        return this.javadocToolFor(this.configureToolchainSpec(config));
    }

    @Override
    public Provider<JavadocTool> javadocToolFor(JavaToolchainSpec spec) {
        return this.queryService.toolFor(spec, JavaToolchain::getJavadocTool, DefaultJavaToolchainUsageProgressDetails.JavaTool.JAVADOC);
    }

    private DefaultToolchainSpec configureToolchainSpec(Action<? super JavaToolchainSpec> config) {
        DefaultToolchainSpec toolchainSpec = (DefaultToolchainSpec)this.objectFactory.newInstance(DefaultToolchainSpec.class, new Object[0]);
        config.execute((Object)toolchainSpec);
        return toolchainSpec;
    }
}

