/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.SystemInfo;
import org.gradle.api.Transformer;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureDescriptorBuilder;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.ArchitectureSpecificVisualCpp;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualCppInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.VisualStudioLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioInstallCandidate;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioMetaDataProvider;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.version.VisualStudioVersionLocator;
import org.gradle.platform.base.internal.toolchain.ComponentFound;
import org.gradle.platform.base.internal.toolchain.ComponentNotFound;
import org.gradle.platform.base.internal.toolchain.SearchResult;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVisualStudioLocator
implements VisualStudioLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVisualStudioLocator.class);
    private static final String PATH_COMMON = "Common7/";
    private static final String PATH_BIN = "bin/";
    private static final String LEGACY_COMPILER_FILENAME = "cl.exe";
    private static final String VS2017_COMPILER_FILENAME = "HostX86/x86/cl.exe";
    private final Map<File, VisualStudioInstall> foundInstalls = new HashMap<File, VisualStudioInstall>();
    private final Set<File> brokenInstalls = new LinkedHashSet<File>();
    private final VisualStudioVersionLocator commandLineLocator;
    private final VisualStudioVersionLocator windowsRegistryLocator;
    private final VisualStudioVersionLocator systemPathLocator;
    private final VisualStudioMetaDataProvider versionDeterminer;
    private final SystemInfo systemInfo;
    private boolean initialised;

    public DefaultVisualStudioLocator(VisualStudioVersionLocator commandLineLocator, VisualStudioVersionLocator windowsRegistryLocator, VisualStudioVersionLocator systemPathLocator, VisualStudioMetaDataProvider versionDeterminer, SystemInfo systemInfo) {
        this.commandLineLocator = commandLineLocator;
        this.windowsRegistryLocator = windowsRegistryLocator;
        this.systemPathLocator = systemPathLocator;
        this.versionDeterminer = versionDeterminer;
        this.systemInfo = systemInfo;
    }

    @Override
    public List<? extends VisualStudioInstall> locateAllComponents() {
        this.initializeVisualStudioInstalls();
        return CollectionUtils.sort(this.foundInstalls.values(), (Comparator)new Comparator<VisualStudioInstall>(){

            @Override
            public int compare(VisualStudioInstall o1, VisualStudioInstall o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
    }

    @Override
    public SearchResult<VisualStudioInstall> locateComponent(@Nullable File candidate) {
        this.initializeVisualStudioInstalls();
        if (candidate != null) {
            return this.locateUserSpecifiedInstall(candidate);
        }
        return this.determineDefaultInstall();
    }

    private void initializeVisualStudioInstalls() {
        if (!this.initialised) {
            this.locateInstallsWith(this.commandLineLocator);
            this.locateInstallsWith(this.windowsRegistryLocator);
            if (this.foundInstalls.isEmpty()) {
                this.locateInstallsWith(this.systemPathLocator);
            }
            this.initialised = true;
        }
    }

    private void locateInstallsWith(VisualStudioVersionLocator versionLocator) {
        List<VisualStudioInstallCandidate> installs = versionLocator.getVisualStudioInstalls();
        for (VisualStudioInstallCandidate install : installs) {
            this.addInstallIfValid(install, versionLocator.getSource());
        }
    }

    private boolean addInstallIfValid(VisualStudioInstallCandidate install, String source) {
        File visualCppDir = install.getVisualCppDir();
        File visualStudioDir = install.getInstallDir();
        if (this.foundInstalls.containsKey(visualStudioDir)) {
            return true;
        }
        if (this.brokenInstalls.contains(visualStudioDir)) {
            return false;
        }
        if (DefaultVisualStudioLocator.isValidInstall(install) && install.getVisualCppVersion() != VersionNumber.UNKNOWN) {
            LOGGER.debug("Found Visual C++ {} at {}", (Object)install.getVisualCppVersion(), (Object)visualCppDir);
            VersionNumber visualStudioVersion = install.getVersion();
            String visualStudioDisplayVersion = install.getVersion() == VersionNumber.UNKNOWN ? "from " + source : install.getVersion().toString();
            VisualCppInstall visualCpp = this.buildVisualCppInstall("Visual C++ " + install.getVisualCppVersion(), visualStudioDir, visualCppDir, install.getVisualCppVersion(), install.getCompatibility());
            VisualStudioInstall visualStudio = new VisualStudioInstall("Visual Studio " + visualStudioDisplayVersion, visualStudioDir, visualStudioVersion, visualCpp);
            this.foundInstalls.put(visualStudioDir, visualStudio);
            return true;
        }
        LOGGER.debug("Ignoring candidate Visual C++ directory {} as it does not look like a Visual C++ installation.", (Object)visualCppDir);
        this.brokenInstalls.add(visualStudioDir);
        return false;
    }

    private SearchResult<VisualStudioInstall> locateUserSpecifiedInstall(File candidate) {
        VisualStudioInstallCandidate install = this.versionDeterminer.getVisualStudioMetadataFromInstallDir(candidate);
        if (install != null && this.addInstallIfValid(install, "user provided path")) {
            return new ComponentFound((Object)this.foundInstalls.get(install.getInstallDir()));
        }
        LOGGER.debug("Ignoring candidate Visual C++ install for {} as it does not look like a Visual C++ installation.", (Object)candidate);
        return new ComponentNotFound(String.format("The specified installation directory '%s' does not appear to contain a Visual Studio installation.", candidate));
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version, VisualStudioInstallCandidate.Compatibility compatibility) {
        switch (compatibility) {
            case LEGACY: {
                return this.buildLegacyVisualCppInstall(name, vsPath, basePath, version);
            }
            case VS2017_OR_LATER: {
                return this.buildVisualCppInstall(name, vsPath, basePath, version);
            }
        }
        throw new IllegalArgumentException("Cannot build VisualCpp install for unknown compatibility level: " + (Object)((Object)compatibility));
    }

    private VisualCppInstall buildLegacyVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        boolean isNativeAmd64;
        ArrayList architectureDescriptorBuilders = Lists.newArrayList();
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_X86_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_AMD64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_IA64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_ARM_ON_X86);
        boolean bl = isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        if (isNativeAmd64) {
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_AMD64_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_X86_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.LEGACY_ARM_ON_AMD64);
        }
        HashMap descriptors = Maps.newHashMap();
        for (ArchitectureDescriptorBuilder architectureDescriptorBuilder : architectureDescriptorBuilders) {
            ArchitectureSpecificVisualCpp descriptor = architectureDescriptorBuilder.buildDescriptor(version, basePath, vsPath);
            if (!descriptor.isInstalled()) continue;
            descriptors.put(architectureDescriptorBuilder.architecture, descriptor);
        }
        return new VisualCppInstall(name, version, descriptors);
    }

    private VisualCppInstall buildVisualCppInstall(String name, File vsPath, File basePath, VersionNumber version) {
        boolean isNativeAmd64;
        ArrayList architectureDescriptorBuilders = Lists.newArrayList();
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_X86);
        architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_X86);
        boolean bl = isNativeAmd64 = this.systemInfo.getArchitecture() == SystemInfo.Architecture.amd64;
        if (isNativeAmd64) {
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.AMD64_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.X86_ON_AMD64);
            architectureDescriptorBuilders.add(ArchitectureDescriptorBuilder.ARM_ON_AMD64);
        }
        HashMap descriptors = Maps.newHashMap();
        for (ArchitectureDescriptorBuilder architectureDescriptorBuilder : architectureDescriptorBuilders) {
            ArchitectureSpecificVisualCpp descriptor = architectureDescriptorBuilder.buildDescriptor(version, basePath, vsPath);
            if (!descriptor.isInstalled()) continue;
            descriptors.put(architectureDescriptorBuilder.architecture, descriptor);
        }
        return new VisualCppInstall(name, version, descriptors);
    }

    private SearchResult<VisualStudioInstall> determineDefaultInstall() {
        VisualStudioInstall candidate = null;
        for (VisualStudioInstall visualStudio : this.foundInstalls.values()) {
            if (candidate != null && visualStudio.getVersion().compareTo(candidate.getVersion()) <= 0) continue;
            candidate = visualStudio;
        }
        if (candidate != null) {
            return new ComponentFound(candidate);
        }
        if (this.brokenInstalls.isEmpty()) {
            return new ComponentNotFound("Could not locate a Visual Studio installation, using the command line tool, Windows registry or system path.");
        }
        return new ComponentNotFound("Could not locate a Visual Studio installation. None of the following locations contain a valid installation", CollectionUtils.collect(this.brokenInstalls, new ArrayList(), (Transformer)new Transformer<String, File>(){

            public String transform(File file) {
                return file.getAbsolutePath();
            }
        }));
    }

    private static boolean isValidInstall(VisualStudioInstallCandidate install) {
        switch (install.getCompatibility()) {
            case LEGACY: {
                return new File(install.getInstallDir(), PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isLegacyVisualCpp(install.getVisualCppDir());
            }
            case VS2017_OR_LATER: {
                return new File(install.getInstallDir(), PATH_COMMON).isDirectory() && DefaultVisualStudioLocator.isVS2017VisualCpp(install.getVisualCppDir());
            }
        }
        throw new IllegalArgumentException("Cannot determine valid install for unknown compatibility: " + (Object)((Object)install.getCompatibility()));
    }

    private static boolean isLegacyVisualCpp(File candidate) {
        return new File(candidate, "bin/cl.exe").isFile();
    }

    private static boolean isVS2017VisualCpp(File candidate) {
        return new File(candidate, "bin/HostX86/x86/cl.exe").isFile();
    }
}

