/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.util.internal.RelativePathUtil;

public class DefaultJavaPluginConvention
extends JavaPluginConvention
implements HasPublicType {
    private final ProjectInternal project;
    private final JavaPluginExtension extension;

    public DefaultJavaPluginConvention(ProjectInternal project, JavaPluginExtension extension) {
        this.project = project;
        this.extension = extension;
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(JavaPluginConvention.class);
    }

    @Override
    public Object sourceSets(Closure closure) {
        return this.extension.sourceSets(closure);
    }

    @Override
    public File getDocsDir() {
        return ((Directory)this.extension.getDocsDir().get()).getAsFile();
    }

    @Override
    public File getTestResultsDir() {
        return ((Directory)this.extension.getTestResultsDir().get()).getAsFile();
    }

    @Override
    public File getTestReportDir() {
        return ((Directory)this.extension.getTestReportDir().get()).getAsFile();
    }

    @Override
    public JavaVersion getSourceCompatibility() {
        return this.extension.getSourceCompatibility();
    }

    @Override
    public void setSourceCompatibility(Object value) {
        this.extension.setSourceCompatibility(value);
    }

    @Override
    public void setSourceCompatibility(JavaVersion value) {
        this.extension.setSourceCompatibility(value);
    }

    @Override
    public JavaVersion getTargetCompatibility() {
        return this.extension.getTargetCompatibility();
    }

    @Override
    public void setTargetCompatibility(Object value) {
        this.extension.setTargetCompatibility(value);
    }

    @Override
    public void setTargetCompatibility(JavaVersion value) {
        this.extension.setTargetCompatibility(value);
    }

    @Override
    public Manifest manifest() {
        return this.extension.manifest();
    }

    @Override
    public Manifest manifest(Closure closure) {
        return this.extension.manifest(closure);
    }

    @Override
    public Manifest manifest(Action<? super Manifest> action) {
        return this.extension.manifest(action);
    }

    @Override
    public String getDocsDirName() {
        return DefaultJavaPluginConvention.relativePath(this.project.getLayout().getBuildDirectory(), this.extension.getDocsDir());
    }

    @Override
    public void setDocsDirName(String docsDirName) {
        this.extension.getDocsDir().set(this.project.getLayout().getBuildDirectory().dir(docsDirName));
    }

    @Override
    public String getTestResultsDirName() {
        return DefaultJavaPluginConvention.relativePath(this.project.getLayout().getBuildDirectory(), this.extension.getTestResultsDir());
    }

    @Override
    public void setTestResultsDirName(String testResultsDirName) {
        this.extension.getTestResultsDir().set(this.project.getLayout().getBuildDirectory().dir(testResultsDirName));
    }

    @Override
    public String getTestReportDirName() {
        return DefaultJavaPluginConvention.relativePath(((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory(), this.extension.getTestReportDir());
    }

    @Override
    public void setTestReportDirName(String testReportDirName) {
        this.extension.getTestReportDir().set(((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDirectory().dir(testReportDirName));
    }

    @Override
    public SourceSetContainer getSourceSets() {
        return this.extension.getSourceSets();
    }

    @Override
    public ProjectInternal getProject() {
        return this.project;
    }

    @Override
    public void disableAutoTargetJvm() {
        this.extension.disableAutoTargetJvm();
    }

    @Override
    public boolean getAutoTargetJvmDisabled() {
        return this.extension.getAutoTargetJvmDisabled();
    }

    private File getReportsDir() {
        return ((ReportingExtension)this.project.getExtensions().getByType(ReportingExtension.class)).getBaseDir();
    }

    private static String relativePath(DirectoryProperty from, DirectoryProperty to) {
        return RelativePathUtil.relativePath((File)((Directory)from.get()).getAsFile(), (File)((Directory)to.get()).getAsFile());
    }
}

