/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.transform.ConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.ImmutableConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.NoMatchConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.SingleMatchConsumerVariantMatchResult;
import org.gradle.api.internal.artifacts.transform.TransformationStep;
import org.gradle.api.internal.attributes.ImmutableAttributes;

class MutableConsumerVariantMatchResult
implements ConsumerVariantMatchResult {
    private int minDepth;
    private final List<ConsumerVariantMatchResult.ConsumerVariant> matches;

    MutableConsumerVariantMatchResult(int estimateSize) {
        this.matches = Lists.newArrayListWithExpectedSize((int)estimateSize);
    }

    public void matched(ImmutableAttributes output, TransformationStep transformationStep, @Nullable ConsumerVariantMatchResult.ConsumerVariant previous, int depth) {
        if (this.minDepth == 0) {
            this.minDepth = depth;
        } else if (depth < this.minDepth) {
            this.matches.clear();
            this.minDepth = depth;
        } else if (depth > this.minDepth) {
            return;
        }
        this.matches.add(new ConsumerVariantMatchResult.ConsumerVariant(output, transformationStep, previous, depth));
    }

    @Override
    public boolean hasMatches() {
        return !this.matches.isEmpty();
    }

    @Override
    public Collection<ConsumerVariantMatchResult.ConsumerVariant> getMatches() {
        return this.matches;
    }

    public ConsumerVariantMatchResult asImmutable() {
        switch (this.matches.size()) {
            case 0: {
                return NoMatchConsumerVariantMatchResult.getInstance();
            }
            case 1: {
                return SingleMatchConsumerVariantMatchResult.of(this.matches.get(0));
            }
        }
        return ImmutableConsumerVariantMatchResult.of(this.matches);
    }
}

