/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io;

import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;

public final class URLUtil {
    public static final Pattern DATA_URI_PATTERN = Pattern.compile("data:([^,;]+/[^,;]+)(;charset(?:=|:)[^,;]+)?(;base64)?,(.+)");
    public static final Pattern URL_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern URL_WITH_PARENS_PATTERN = Pattern.compile("\\b(mailto:|(news|(ht|f)tp(s?))://|((?<![\\p{L}0-9_.])(www\\.)))[-A-Za-z0-9+$&@#/%?=~_|!:,.;()]*[-A-Za-z0-9+$&@#/%=~_|()]");
    public static final Pattern FILE_URL_PATTERN = Pattern.compile("\\b(file:///)[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]");
    public static final Pattern HREF_PATTERN = Pattern.compile("<a(?:\\s+href\\s*=\\s*[\"']([^\"']*)[\"'])?\\s*>([^<]*)</a>");

    @NotNull
    public static String unescapePercentSequences(@NotNull String s) {
        if (s == null) {
            URLUtil.$$$reportNull$$$0(15);
        }
        String string2 = URLUtil.unescapePercentSequences(s, 0, s.length()).toString();
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @NotNull
    public static CharSequence unescapePercentSequences(@NotNull CharSequence s, int from2, int end) {
        int i;
        if (s == null) {
            URLUtil.$$$reportNull$$$0(17);
        }
        if ((i = Strings.indexOf(s, '%', from2, end)) == -1) {
            CharSequence charSequence2 = s.subSequence(from2, end);
            if (charSequence2 == null) {
                URLUtil.$$$reportNull$$$0(18);
            }
            return charSequence2;
        }
        StringBuilder decoded = new StringBuilder();
        decoded.append(s, from2, i);
        byte[] byteBuffer = null;
        int byteBufferSize = 0;
        while (i < end) {
            char c = s.charAt(i);
            if (c == '%') {
                if (byteBuffer == null) {
                    byteBuffer = new byte[end - from2];
                } else {
                    byteBufferSize = 0;
                }
                while (i + 2 < end && s.charAt(i) == '%') {
                    int d1 = URLUtil.decode(s.charAt(i + 1));
                    int d2 = URLUtil.decode(s.charAt(i + 2));
                    if (d1 == -1 || d2 == -1) break;
                    byteBuffer[byteBufferSize++] = (byte)((d1 & 0xF) << 4 | d2 & 0xF);
                    i += 3;
                }
                if (byteBufferSize != 0) {
                    decoded.append(new String(byteBuffer, 0, byteBufferSize, StandardCharsets.UTF_8));
                    continue;
                }
            }
            decoded.append(c);
            ++i;
        }
        StringBuilder stringBuilder2 = decoded;
        if (stringBuilder2 == null) {
            URLUtil.$$$reportNull$$$0(19);
        }
        return stringBuilder2;
    }

    private static int decode(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index2;
        if (url == null) {
            URLUtil.$$$reportNull$$$0(34);
        }
        String string2 = (index2 = url.indexOf("://")) >= 0 ? url.substring(index2 + "://".length()) : url;
        if (string2 == null) {
            URLUtil.$$$reportNull$$$0(35);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/io/URLUtil";
                break;
            }
            case 15: 
            case 17: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataUrl";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sshUrl";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/URLUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "openStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openResourceStream";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resourceExists";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapePercentSequences";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "decode";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHostFromSshUrl";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeURIComponent";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canContainUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "openStream";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openResourceStream";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "openJarStream";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resourceExists";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "splitJarUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "urlToFile";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapePercentSequences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isDataUri";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getBytesFromDataUri";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "decode";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseHostFromSshUrl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getJarEntryURL";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "encodeURIComponent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findUrl";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 27: 
            case 31: 
            case 32: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

