/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configurationcache.serialization.codecs;

import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ExtraExecutionGraphDependenciesResolverFactory;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.artifacts.transform.VariantSelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.configurationcache.serialization.codecs.EmptyDependenciesResolverFactory;
import org.gradle.configurationcache.serialization.codecs.IdentityMapping;
import org.gradle.configurationcache.serialization.codecs.MappingSpec;
import org.gradle.configurationcache.serialization.codecs.TransformMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gradle/configurationcache/serialization/codecs/FixedVariantSelector;", "Lorg/gradle/api/internal/artifacts/transform/VariantSelector;", "matchingOnArtifactFormat", "", "transforms", "", "Lorg/gradle/api/internal/attributes/ImmutableAttributes;", "Lorg/gradle/configurationcache/serialization/codecs/MappingSpec;", "fileCollectionFactory", "Lorg/gradle/api/internal/file/FileCollectionFactory;", "transformedVariantFactory", "Lorg/gradle/api/internal/artifacts/transform/TransformedVariantFactory;", "(ZLjava/util/Map;Lorg/gradle/api/internal/file/FileCollectionFactory;Lorg/gradle/api/internal/artifacts/transform/TransformedVariantFactory;)V", "getRequestedAttributes", "", "select", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedArtifactSet;", "candidates", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedVariantSet;", "factory", "Lorg/gradle/api/internal/artifacts/transform/VariantSelector$Factory;", "configuration-cache"})
final class FixedVariantSelector
implements VariantSelector {
    private final boolean matchingOnArtifactFormat;
    @NotNull
    private final Map<ImmutableAttributes, MappingSpec> transforms;
    @NotNull
    private final FileCollectionFactory fileCollectionFactory;
    @NotNull
    private final TransformedVariantFactory transformedVariantFactory;

    public FixedVariantSelector(boolean matchingOnArtifactFormat, @NotNull Map<ImmutableAttributes, ? extends MappingSpec> transforms, @NotNull FileCollectionFactory fileCollectionFactory, @NotNull TransformedVariantFactory transformedVariantFactory) {
        Intrinsics.checkNotNullParameter(transforms, (String)"transforms");
        Intrinsics.checkNotNullParameter((Object)fileCollectionFactory, (String)"fileCollectionFactory");
        Intrinsics.checkNotNullParameter((Object)transformedVariantFactory, (String)"transformedVariantFactory");
        this.matchingOnArtifactFormat = matchingOnArtifactFormat;
        this.transforms = transforms;
        this.fileCollectionFactory = fileCollectionFactory;
        this.transformedVariantFactory = transformedVariantFactory;
    }

    @NotNull
    public Void getRequestedAttributes() {
        throw new UnsupportedOperationException("Should not be called");
    }

    @NotNull
    public ResolvedArtifactSet select(@NotNull ResolvedVariantSet candidates, @NotNull VariantSelector.Factory factory) {
        ResolvedArtifactSet resolvedArtifactSet;
        Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (!(candidates.getVariants().size() == 1)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        Set set2 = candidates.getVariants();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"candidates.variants");
        ResolvedVariant variant = (ResolvedVariant)CollectionsKt.first((Iterable)set2);
        MappingSpec spec = this.transforms.get(variant.getAttributes().asImmutable());
        if (spec == null) {
            ResolvedArtifactSet resolvedArtifactSet2 = this.matchingOnArtifactFormat ? ResolvedArtifactSet.EMPTY : variant.getArtifacts();
            resolvedArtifactSet = resolvedArtifactSet2;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet2, (String)"{\n                // no \u2026          }\n            }");
        } else if (spec instanceof IdentityMapping) {
            ResolvedArtifactSet resolvedArtifactSet3 = variant.getArtifacts();
            resolvedArtifactSet = resolvedArtifactSet3;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet3, (String)"variant.artifacts");
        } else if (spec instanceof TransformMapping) {
            ResolvedArtifactSet resolvedArtifactSet4 = factory.asTransformed(variant, (VariantDefinition)spec, (ExtraExecutionGraphDependenciesResolverFactory)new EmptyDependenciesResolverFactory(this.fileCollectionFactory), this.transformedVariantFactory);
            resolvedArtifactSet = resolvedArtifactSet4;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet4, (String)"factory.asTransformed(va\u2026ransformedVariantFactory)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvedArtifactSet;
    }
}

