/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhase;
import org.jetbrains.kotlin.backend.common.phaser.CompilerPhaseKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.wasm.CompilerKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoaderKind;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleFragmentGenerator;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.KlibKt;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.ModulesStructure;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.SymbolTableKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a0\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u000f2\b\b\u0002\u0010\u0015\u001a\u00020\u000f\u001a\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017\u001a(\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\b\b\u0002\u0010\"\u001a\u00020\u0017\u001a\n\u0010#\u001a\u00020\u0017*\u00020$\u00a8\u0006%"}, d2={"compileToLoweredIr", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "depsDescriptors", "Lorg/jetbrains/kotlin/ir/backend/js/ModulesStructure;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "propertyLazyInitialization", "", "compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "allModules", "backendContext", "emitNameSection", "allowIncompleteImplementations", "generateJsWasmLoader", "", "kind", "Lorg/jetbrains/kotlin/backend/wasm/WasmLoaderKind;", "wasmFilePath", "externalJs", "writeCompilationResult", "", "result", "dir", "Ljava/io/File;", "loaderKind", "fileNameBase", "generateJs", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "backend.wasm"})
public final class CompilerKt {
    @NotNull
    public static final Pair<List<IrModuleFragment>, WasmBackendContext> compileToLoweredIr(@NotNull ModulesStructure depsDescriptors, @NotNull PhaseConfig phaseConfig, @NotNull IrFactory irFactory, @NotNull Set<FqName> exportedDeclarations, boolean propertyLazyInitialization) {
        IrModuleFragment it;
        List list2;
        Intrinsics.checkNotNullParameter((Object)depsDescriptors, (String)"depsDescriptors");
        Intrinsics.checkNotNullParameter((Object)phaseConfig, (String)"phaseConfig");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter(exportedDeclarations, (String)"exportedDeclarations");
        MainModule mainModule = depsDescriptors.getMainModule();
        CompilerConfiguration configuration2 = depsDescriptors.getCompilerConfiguration();
        IrModuleInfo irModuleInfo = KlibKt.loadIr$default(depsDescriptors, irFactory, false, null, true, 8, null);
        IrModuleFragment moduleFragment2 = irModuleInfo.component1();
        List dependencyModules = irModuleInfo.component2();
        IrBuiltIns irBuiltIns = irModuleInfo.component3();
        SymbolTable symbolTable = irModuleInfo.component4();
        JsIrLinker deserializer = irModuleInfo.component5();
        MainModule mainModule2 = mainModule;
        if (mainModule2 instanceof MainModule.SourceFiles) {
            list2 = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf((Object)moduleFragment2));
        } else if (mainModule2 instanceof MainModule.Klib) {
            list2 = dependencyModules;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List allModules2 = list2;
        ModuleDescriptor moduleDescriptor = moduleFragment2.getDescriptor();
        WasmBackendContext context = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment2, propertyLazyInitialization, configuration2);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer)).generateUnboundSymbolsAsDependencies();
        }
        new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf((Object)deserializer)).generateUnboundSymbolsAsDependencies();
        $this$forEach$iv = allModules2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrModuleFragment)element$iv;
            boolean bl = false;
            PatchDeclarationParentsKt.patchDeclarationParents$default(it, null, 1, null);
        }
        deserializer.postProcess();
        SymbolTableKt.noUnboundLeft(symbolTable, "Unbound symbols at the end of linker");
        for (IrModuleFragment module2 : allModules2) {
            for (IrFile file2 : module2.getFiles()) {
                MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context, file2, exportedDeclarations);
            }
        }
        CompilerPhaseKt.invokeToplevel((CompilerPhase)WasmLoweringPhasesKt.getWasmPhases(), phaseConfig, (CommonBackendContext)context, allModules2);
        return new Pair((Object)allModules2, (Object)context);
    }

    public static /* synthetic */ Pair compileToLoweredIr$default(ModulesStructure modulesStructure, PhaseConfig phaseConfig, IrFactory irFactory, Set set, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return CompilerKt.compileToLoweredIr(modulesStructure, phaseConfig, irFactory, set, bl);
    }

    @NotNull
    public static final WasmCompilerResult compileWasm(@NotNull List<? extends IrModuleFragment> allModules2, @NotNull WasmBackendContext backendContext, boolean emitNameSection, boolean allowIncompleteImplementations) {
        Intrinsics.checkNotNullParameter(allModules2, (String)"allModules");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        WasmCompiledModuleFragment compiledWasmModule = new WasmCompiledModuleFragment(backendContext.getIrBuiltIns());
        WasmModuleFragmentGenerator codeGenerator = new WasmModuleFragmentGenerator(backendContext, compiledWasmModule, allowIncompleteImplementations);
        Iterable $this$forEach$iv = allModules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl = false;
            codeGenerator.generateModule(it);
        }
        WasmModule linkedModule = compiledWasmModule.linkWasmCompiledFragments();
        WasmIrToText watGenerator = new WasmIrToText();
        watGenerator.appendWasmModule(linkedModule);
        String wat = watGenerator.toString();
        String js = CompilerKt.generateJs(compiledWasmModule);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        OutputStream outputStream2 = os;
        String string2 = ((IrModuleFragment)CollectionsKt.last(allModules2)).getDescriptor().getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"allModules.last().descriptor.name.asString()");
        new WasmIrToBinary(outputStream2, linkedModule, string2, emitNameSection).appendWasmModule();
        byte[] byteArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byteArray, (String)"byteArray");
        return new WasmCompilerResult(wat, js, byteArray);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm$default(List list2, WasmBackendContext wasmBackendContext, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return CompilerKt.compileWasm(list2, wasmBackendContext, bl, bl2);
    }

    @NotNull
    public static final String generateJs(@NotNull WasmCompiledModuleFragment $this$generateJs) {
        Intrinsics.checkNotNullParameter((Object)$this$generateJs, (String)"<this>");
        String runtime = "\nconst externrefBoxes = new WeakMap();";
        String jsCodeBody2 = CollectionsKt.joinToString$default((Iterable)$this$generateJs.getJsFuns(), (CharSequence)",\n", null, null, (int)0, null, (Function1)generateJs.jsCodeBody.1.INSTANCE, (int)30, null);
        String jsCodeBodyIndented = StringsKt.prependIndent((String)jsCodeBody2, (String)"    ");
        String jsCode = "\nconst js_code = {\n" + jsCodeBodyIndented + "\n};\n";
        return runtime + jsCode;
    }

    @NotNull
    public static final String generateJsWasmLoader(@NotNull WasmLoaderKind kind, @NotNull String wasmFilePath, @NotNull String externalJs) {
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)wasmFilePath, (String)"wasmFilePath");
        Intrinsics.checkNotNullParameter((Object)externalJs, (String)"externalJs");
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                string3 = StringsKt.trimIndent((String)("\n                const wasmModule = new WebAssembly.Module(read('" + wasmFilePath + "', 'binary'));\n                const wasmInstance = new WebAssembly.Instance(wasmModule, { js_code });\n            "));
                break;
            }
            case 2: {
                string3 = StringsKt.trimIndent((String)("\n                const fs = require('fs');\n                var path = require('path');\n                const wasmBuffer = fs.readFileSync(path.resolve(__dirname, './" + wasmFilePath + "'));\n                const wasmModule = new WebAssembly.Module(wasmBuffer);\n                const wasmInstance = new WebAssembly.Instance(wasmModule, { js_code });\n            "));
                break;
            }
            case 3: {
                string3 = StringsKt.trimIndent((String)("\n                const { wasmInstance } = await WebAssembly.instantiateStreaming(fetch(\"" + wasmFilePath + "\"), { js_code });\n            "));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String instantiation = string3;
        String init2 = "\nconst wasmExports = wasmInstance.exports;\nwasmExports.__init();\nwasmExports.startUnitTests?.();\n";
        switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: 
            case 3: {
                string2 = "export default wasmExports;\n";
                break;
            }
            case 2: {
                string2 = "module.exports = wasmExports;\n";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String export = string2;
        return externalJs + instantiation + init2 + export;
    }

    public static final void writeCompilationResult(@NotNull WasmCompilerResult result2, @NotNull File dir, @NotNull WasmLoaderKind loaderKind, @NotNull String fileNameBase) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)loaderKind), (String)"loaderKind");
        Intrinsics.checkNotNullParameter((Object)fileNameBase, (String)"fileNameBase");
        dir.mkdirs();
        FilesKt.writeText$default((File)new File(dir, fileNameBase + ".wat"), (String)result2.getWat(), null, (int)2, null);
        FilesKt.writeBytes((File)new File(dir, fileNameBase + ".wasm"), (byte[])result2.getWasm());
        String jsWithLoader = CompilerKt.generateJsWasmLoader(loaderKind, "./" + fileNameBase + ".wasm", result2.getJs());
        FilesKt.writeText$default((File)new File(dir, fileNameBase + ".js"), (String)jsWithLoader, null, (int)2, null);
    }

    public static /* synthetic */ void writeCompilationResult$default(WasmCompilerResult wasmCompilerResult, File file2, WasmLoaderKind wasmLoaderKind, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "index";
        }
        CompilerKt.writeCompilationResult(wasmCompilerResult, file2, wasmLoaderKind, string2);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WasmLoaderKind.values().length];
            nArray[WasmLoaderKind.D8.ordinal()] = 1;
            nArray[WasmLoaderKind.NODE.ordinal()] = 2;
            nArray[WasmLoaderKind.BROWSER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

