/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.callsite.AbstractCallSite;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.vmplugin.v8.CacheableCallSite;
import org.gradle.api.GradleException;
import org.gradle.internal.classpath.intercept.AbstractInvocation;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;

public class CallInterceptorsSet {
    private final Map<InterceptScope, CallInterceptor> interceptors = new HashMap<InterceptScope, CallInterceptor>();
    private final Set<String> interceptedCallSiteNames = new HashSet<String>();
    private final CallInterceptor dispatchingConstructorInterceptor = new CallInterceptor(new InterceptScope[0]){

        @Override
        protected Object doIntercept(Invocation invocation, String consumer) throws Throwable {
            CallInterceptor realConstructorInterceptor;
            Object receiver = invocation.getReceiver();
            if (receiver instanceof Class && (realConstructorInterceptor = (CallInterceptor)CallInterceptorsSet.this.interceptors.get(InterceptScope.constructorsOf((Class)receiver))) != null) {
                return realConstructorInterceptor.doIntercept(invocation, consumer);
            }
            return invocation.callOriginal();
        }
    };

    public CallInterceptorsSet(CallInterceptor ... interceptors) {
        for (CallInterceptor interceptor : interceptors) {
            this.addInterceptor(interceptor);
        }
    }

    private void addInterceptor(CallInterceptor interceptor) {
        for (InterceptScope scope : interceptor.getInterceptScopes()) {
            CallInterceptor oldInterceptor = this.interceptors.put(scope, interceptor);
            if (oldInterceptor != null) {
                throw new IllegalArgumentException("Interceptor " + interceptor + " attempted to overwrite already registered " + oldInterceptor + " in the scope " + scope);
            }
            this.interceptedCallSiteNames.add(scope.getCallSiteName());
        }
    }

    public java.lang.invoke.CallSite maybeDecorateIndyCallSite(java.lang.invoke.CallSite originalCallSite, MethodHandles.Lookup caller, String callType, String name, int flags) {
        CacheableCallSite ccs = CallInterceptorsSet.toGroovyCacheableCallSite(originalCallSite);
        switch (callType) {
            case "invoke": {
                CallInterceptorsSet.maybeApplyInterceptor(ccs, caller, flags, this.interceptors.get(InterceptScope.methodsNamed(name)));
                break;
            }
            case "getProperty": {
                CallInterceptorsSet.maybeApplyInterceptor(ccs, caller, flags, this.interceptors.get(InterceptScope.readsOfPropertiesNamed(name)));
                break;
            }
            case "init": {
                CallInterceptorsSet.maybeApplyInterceptor(ccs, caller, flags, this.dispatchingConstructorInterceptor);
            }
        }
        return ccs;
    }

    private static void maybeApplyInterceptor(CacheableCallSite cs, MethodHandles.Lookup caller, int flags, @Nullable CallInterceptor interceptor) {
        if (interceptor == null) {
            return;
        }
        MethodHandle defaultTarget = interceptor.decorateMethodHandle(cs.getDefaultTarget(), caller, flags);
        cs.setTarget(defaultTarget);
        cs.setDefaultTarget(defaultTarget);
        cs.setFallbackTarget(interceptor.decorateMethodHandle(cs.getFallbackTarget(), caller, flags));
    }

    private static CacheableCallSite toGroovyCacheableCallSite(java.lang.invoke.CallSite cs) {
        if (!(cs instanceof CacheableCallSite)) {
            throw new GradleException("Groovy produced unrecognized call site type of " + cs.getClass());
        }
        return (CacheableCallSite)cs;
    }

    public CallSite maybeDecorateGroovyCallSite(CallSite originalCallSite) {
        if (this.shouldDecorate(originalCallSite)) {
            return new DecoratingCallSite(originalCallSite);
        }
        return originalCallSite;
    }

    private boolean shouldDecorate(CallSite callSite) {
        return this.interceptedCallSiteNames.contains(callSite.getName());
    }

    private class DecoratingCallSite
    extends AbstractCallSite {
        public DecoratingCallSite(CallSite prev) {
            super(prev);
        }

        public Object call(Object receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = (CallInterceptor)CallInterceptorsSet.this.interceptors.get(InterceptScope.methodsNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.doIntercept(new AbstractInvocation<Object>(receiver, args){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.call(this.receiver, this.args);
                    }
                }, this.array.owner.getName());
            }
            return super.call(receiver, args);
        }

        public Object callGetProperty(Object receiver) throws Throwable {
            CallInterceptor interceptor = (CallInterceptor)CallInterceptorsSet.this.interceptors.get(InterceptScope.readsOfPropertiesNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.doIntercept(new AbstractInvocation<Object>(receiver, new Object[0]){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.callGetProperty(this.receiver);
                    }
                }, this.array.owner.getName());
            }
            return super.callGetProperty(receiver);
        }

        public Object callStatic(Class receiver, Object[] args) throws Throwable {
            CallInterceptor interceptor = (CallInterceptor)CallInterceptorsSet.this.interceptors.get(InterceptScope.methodsNamed(this.getName()));
            if (interceptor != null) {
                return interceptor.doIntercept(new AbstractInvocation<Class<?>>(receiver, args){

                    @Override
                    public Object callOriginal() throws Throwable {
                        return DecoratingCallSite.super.callStatic((Class)this.receiver, this.args);
                    }
                }, this.array.owner.getName());
            }
            return super.callStatic(receiver, args);
        }

        public Object callConstructor(Object receiver, Object[] args) throws Throwable {
            return CallInterceptorsSet.this.dispatchingConstructorInterceptor.doIntercept(new AbstractInvocation<Object>(receiver, args){

                @Override
                public Object callOriginal() throws Throwable {
                    return DecoratingCallSite.super.callConstructor(this.receiver, this.args);
                }
            }, this.array.owner.getName());
        }
    }
}

