/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.Collection;
import java.util.List;
import org.gradle.api.capabilities.Capability;
import org.gradle.internal.component.CapabilitiesSupport;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;

public class NoMatchingCapabilitiesException
extends RuntimeException {
    public NoMatchingCapabilitiesException(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveMetadata> candidates) {
        super(NoMatchingCapabilitiesException.buildMessage(targetComponent, requestedCapabilities, candidates));
    }

    private static String buildMessage(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveMetadata> candidates) {
        StringBuilder sb = new StringBuilder("Unable to find a variant of ");
        sb.append(targetComponent.getId()).append(" providing the requested ");
        sb.append(CapabilitiesSupport.prettifyCapabilities(targetComponent, requestedCapabilities));
        sb.append(":\n");
        for (VariantGraphResolveMetadata variantGraphResolveMetadata : candidates) {
            sb.append("   - Variant ").append(variantGraphResolveMetadata.getName()).append(" provides ");
            sb.append(CapabilitiesSupport.sortedCapabilityList(targetComponent, variantGraphResolveMetadata.getCapabilities().getCapabilities())).append("\n");
        }
        return sb.toString();
    }
}

