/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.antlr.AntlrSourceDirectorySet;
import org.gradle.api.plugins.antlr.AntlrTask;
import org.gradle.api.plugins.antlr.internal.AntlrSourceVirtualDirectoryImpl;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.deprecation.DeprecatableConfiguration;

public class AntlrPlugin
implements Plugin<Project> {
    public static final String ANTLR_CONFIGURATION_NAME = "antlr";
    private final ObjectFactory objectFactory;

    @Inject
    public AntlrPlugin(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void apply(final Project project) {
        project.getPluginManager().apply(JavaLibraryPlugin.class);
        Configuration antlrConfiguration = ((Configuration)project.getConfigurations().create(ANTLR_CONFIGURATION_NAME)).setVisible(false).setDescription("The Antlr libraries to be used for this project.");
        ((DeprecatableConfiguration)antlrConfiguration).deprecateForConsumption(deprecation -> deprecation.willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "plugin_configuration_consumption"));
        antlrConfiguration.defaultDependencies(dependencies -> dependencies.add((Object)project.getDependencies().create((Object)"antlr:antlr:2.7.7@jar")));
        Configuration apiConfiguration = project.getConfigurations().getByName("api");
        apiConfiguration.extendsFrom(new Configuration[]{antlrConfiguration});
        project.getTasks().withType(AntlrTask.class).configureEach(antlrTask -> antlrTask.getConventionMapping().map("antlrClasspath", () -> project.getConfigurations().getByName(ANTLR_CONFIGURATION_NAME)));
        ((JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class)).getSourceSets().all((Action)new Action<SourceSet>(){

            public void execute(final SourceSet sourceSet) {
                final AntlrSourceVirtualDirectoryImpl antlrDirectoryDelegate = new AntlrSourceVirtualDirectoryImpl(((DefaultSourceSet)sourceSet).getDisplayName(), AntlrPlugin.this.objectFactory);
                new DslObject((Object)sourceSet).getConvention().getPlugins().put(AntlrPlugin.ANTLR_CONFIGURATION_NAME, antlrDirectoryDelegate);
                sourceSet.getExtensions().add(AntlrSourceDirectorySet.class, AntlrPlugin.ANTLR_CONFIGURATION_NAME, (Object)antlrDirectoryDelegate.getAntlr());
                String srcDir = "src/" + sourceSet.getName() + "/antlr";
                antlrDirectoryDelegate.getAntlr().srcDir(srcDir);
                sourceSet.getAllSource().source((SourceDirectorySet)antlrDirectoryDelegate.getAntlr());
                final String taskName = sourceSet.getTaskName("generate", "GrammarSource");
                String outputDirectoryName = project.getBuildDir() + "/generated-src/antlr/" + sourceSet.getName();
                final File outputDirectory = new File(outputDirectoryName);
                sourceSet.getJava().srcDir((Object)outputDirectory);
                project.getTasks().register(taskName, AntlrTask.class, (Action)new Action<AntlrTask>(){

                    public void execute(AntlrTask antlrTask) {
                        antlrTask.setDescription("Processes the " + sourceSet.getName() + " Antlr grammars.");
                        antlrTask.setSource((FileTree)antlrDirectoryDelegate.getAntlr());
                        antlrTask.setOutputDirectory(outputDirectory);
                    }
                });
                project.getTasks().named(sourceSet.getCompileJavaTaskName(), (Action)new Action<Task>(){

                    public void execute(Task task) {
                        task.dependsOn(new Object[]{taskName});
                    }
                });
            }
        });
    }
}

