/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.metadata;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleDescriptorHashModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.DescriptorParseContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.repositories.maven.MavenMetadataLoader;
import org.gradle.api.internal.artifacts.repositories.maven.MavenVersionLister;
import org.gradle.api.internal.artifacts.repositories.metadata.AbstractRepositoryMetadataSource;
import org.gradle.api.internal.artifacts.repositories.metadata.MetadataArtifactProvider;
import org.gradle.api.internal.artifacts.repositories.resolver.ExternalResourceArtifactResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenUniqueSnapshotComponentIdentifier;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.VersionLister;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resource.local.FileResourceRepository;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;

public class DefaultMavenPomMetadataSource
extends AbstractRepositoryMetadataSource<MutableMavenModuleResolveMetadata> {
    private final MetaDataParser<MutableMavenModuleResolveMetadata> pomParser;
    private final MavenMetadataValidator validator;
    private final MavenMetadataLoader mavenMetadataLoader;
    private final ChecksumService checksumService;

    @Inject
    public DefaultMavenPomMetadataSource(MetadataArtifactProvider metadataArtifactProvider, MetaDataParser<MutableMavenModuleResolveMetadata> pomParser, FileResourceRepository fileResourceRepository, MavenMetadataValidator validator, MavenMetadataLoader mavenMetadataLoader, ChecksumService checksumService) {
        super(metadataArtifactProvider, fileResourceRepository, checksumService);
        this.pomParser = pomParser;
        this.validator = validator;
        this.mavenMetadataLoader = mavenMetadataLoader;
        this.checksumService = checksumService;
    }

    @Override
    protected MetaDataParser.ParseResult<MutableMavenModuleResolveMetadata> parseMetaDataFromResource(ModuleComponentIdentifier moduleComponentIdentifier, LocallyAvailableExternalResource cachedResource, ExternalResourceArtifactResolver artifactResolver, DescriptorParseContext context, String repoName) {
        MetaDataParser.ParseResult<MutableMavenModuleResolveMetadata> parseResult = this.pomParser.parseMetaData(context, cachedResource);
        MutableMavenModuleResolveMetadata metaData = parseResult.getResult();
        if (metaData != null) {
            if (moduleComponentIdentifier instanceof MavenUniqueSnapshotComponentIdentifier) {
                MavenUniqueSnapshotComponentIdentifier snapshotComponentIdentifier = (MavenUniqueSnapshotComponentIdentifier)moduleComponentIdentifier;
                this.checkMetadataConsistency(snapshotComponentIdentifier.getSnapshotComponent(), metaData);
                metaData.setId(snapshotComponentIdentifier);
                metaData.setSnapshotTimestamp(snapshotComponentIdentifier.getTimestamp());
            } else {
                this.checkMetadataConsistency(moduleComponentIdentifier, metaData);
            }
            MutableMavenModuleResolveMetadata result = MavenResolver.processMetaData(metaData);
            result.getSources().add(new ModuleDescriptorHashModuleSource(this.checksumService.md5(cachedResource.getFile()), metaData.isChanging()));
            if (this.validator.isUsableModule(repoName, result, artifactResolver)) {
                return parseResult;
            }
            return null;
        }
        return parseResult;
    }

    @Override
    public void listModuleVersions(ModuleDependencyMetadata dependency, ModuleIdentifier module, List<ResourcePattern> ivyPatterns, List<ResourcePattern> artifactPatterns, VersionLister versionLister, BuildableModuleVersionListingResolveResult result) {
        new MavenVersionLister(this.mavenMetadataLoader).listVersions(module, ivyPatterns, result);
    }

    public static interface MavenMetadataValidator {
        public boolean isUsableModule(String var1, MutableMavenModuleResolveMetadata var2, ExternalResourceArtifactResolver var3);
    }
}

