/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingManager;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Serializer;

public class ReadOnlyArtifactCacheLockingManager
implements ArtifactCacheLockingManager,
Closeable {
    private static final Logger LOGGER = Logging.getLogger(ReadOnlyArtifactCacheLockingManager.class);
    private final PersistentCache cache;

    public ReadOnlyArtifactCacheLockingManager(CacheRepository cacheRepository, ArtifactCacheMetadata cacheMetaData) {
        this.cache = cacheRepository.cache(cacheMetaData.getCacheDir()).withCrossVersionCache(CacheBuilder.LockTarget.CacheDirectory).withDisplayName("read only artifact cache").withLockOptions((LockOptions)LockOptionsBuilder.mode((FileLockManager.LockMode)FileLockManager.LockMode.None)).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public <T> T withFileLock(Factory<? extends T> action) {
        return (T)this.cache.withFileLock(action);
    }

    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    public <T> T useCache(Factory<? extends T> action) {
        return (T)this.cache.useCache(action);
    }

    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> PersistentIndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        PersistentIndexedCacheParameters parameters = PersistentIndexedCacheParameters.of((String)cacheFileInMetaDataStore, keySerializer, valueSerializer);
        if (this.cache.cacheExists(parameters)) {
            return new TransparentCacheLockingPersistentCache(new FailSafePersistentCache(this.cache.createCache(parameters)));
        }
        return new EmptyCache();
    }

    private class TransparentCacheLockingPersistentCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private final PersistentIndexedCache<K, V> persistentCache;

        public TransparentCacheLockingPersistentCache(PersistentIndexedCache<K, V> persistentCache) {
            this.persistentCache = persistentCache;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)ReadOnlyArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)ReadOnlyArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.get(key, producer));
        }

        public void put(K key, V value) {
            ReadOnlyArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.put(key, value));
        }

        public void remove(K key) {
            ReadOnlyArtifactCacheLockingManager.this.cache.useCache(() -> this.persistentCache.remove(key));
        }
    }

    private static class FailSafePersistentCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private final PersistentIndexedCache<K, V> delegate;
        private boolean failed;

        private FailSafePersistentCache(PersistentIndexedCache<K, V> delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)this.failSafe(() -> this.delegate.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)this.failSafe(() -> this.delegate.get(key, producer));
        }

        public void put(K key, V value) {
        }

        public void remove(K key) {
        }

        private <T> T failSafe(Factory<T> operation) {
            if (this.failed) {
                return null;
            }
            try {
                return (T)operation.create();
            }
            catch (Exception ex) {
                this.failed = true;
                LOGGER.debug("Error accessing read-only cache", (Throwable)ex);
                return null;
            }
        }
    }

    private static class EmptyCache<K, V>
    implements PersistentIndexedCache<K, V> {
        private EmptyCache() {
        }

        @Nullable
        public V getIfPresent(K key) {
            return null;
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return producer.apply(key);
        }

        public void put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        public void remove(K key) {
            throw new UnsupportedOperationException();
        }
    }
}

