/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import java.util.Optional;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.TaskExecutionTracker;

public class BuildServiceProviderNagger
implements BuildServiceProvider.Listener {
    private final TaskExecutionTracker taskExecutionTracker;

    public BuildServiceProviderNagger(TaskExecutionTracker taskExecutionTracker) {
        this.taskExecutionTracker = taskExecutionTracker;
    }

    @Override
    public void beforeGet(BuildServiceProvider<?, ?> provider) {
        this.currentTask().ifPresent(task -> {
            if (!BuildServiceProviderNagger.isServiceRequiredBy(task, provider)) {
                BuildServiceProviderNagger.nagAboutUndeclaredUsageOf(provider, task);
            }
        });
    }

    private Optional<TaskInternal> currentTask() {
        return this.taskExecutionTracker.getCurrentTask();
    }

    private static boolean isServiceRequiredBy(TaskInternal task, BuildServiceProvider<?, ?> provider) {
        return task.getRequiredServices().contains(provider);
    }

    private static void nagAboutUndeclaredUsageOf(BuildServiceProvider<?, ?> provider, TaskInternal task) {
        ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)BuildServiceProviderNagger.undeclaredBuildServiceUsage(provider, task)).withAdvice("Declare the association between the task and the build service using 'Task#usesService'.")).willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "undeclared_build_service_usage").nagUser();
    }

    private static String undeclaredBuildServiceUsage(BuildServiceProvider<?, ?> provider, TaskInternal task) {
        return "Build service '" + provider.getName() + "' is being used by task '" + task.getIdentityPath() + "' without the corresponding declaration via 'Task#usesService'.";
    }
}

