/*
 * Copyright 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.gradle.ide.xcode

import org.gradle.nativeplatform.fixtures.app.SwiftLib
import org.gradle.nativeplatform.fixtures.app.SwiftSourceElement

class XcodeSwiftBothLibraryLinkageProjectIntegrationTest extends AbstractXcodeSwiftProjectIntegrationTest {
    @Override
    void makeSingleProject() {
        buildFile << """
            apply plugin: 'swift-library'
            library.linkage = [Linkage.STATIC, Linkage.SHARED]
        """
    }

    @Override
    String getComponentUnderTestDsl() {
        return 'library'
    }

    @Override
    protected SwiftSourceElement getComponentUnderTest() {
        return new SwiftLib()
    }
}
