/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api.jcajce;

import java.security.Provider;
import java.util.Date;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.api.OpenPGPV6KeyGenerator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaAEADSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaCFBSecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyPairGeneratorProvider;

public class JcaOpenPGPV6KeyGenerator
extends OpenPGPV6KeyGenerator {
    public JcaOpenPGPV6KeyGenerator(Provider provider) throws PGPException {
        this(new Date(), provider);
    }

    public JcaOpenPGPV6KeyGenerator(Date date, Provider provider) throws PGPException {
        this(14, date, true, provider);
    }

    public JcaOpenPGPV6KeyGenerator(int n, Provider provider) throws PGPException {
        this(n, new Date(), true, provider);
    }

    public JcaOpenPGPV6KeyGenerator(int n, Date date, boolean bl, Provider provider) throws PGPException {
        super(new JcaPGPKeyPairGeneratorProvider().setProvider(provider), new JcaPGPContentSignerBuilderProvider(n).setSecurityProvider(provider), new JcaPGPDigestCalculatorProviderBuilder().setProvider(provider).build(), JcaOpenPGPV6KeyGenerator.keyEncryptorFactory(provider, bl), new JcaKeyFingerprintCalculator(), date);
    }

    private static PBESecretKeyEncryptorFactory keyEncryptorFactory(Provider provider, boolean bl) throws PGPException {
        if (bl) {
            return new JcaAEADSecretKeyEncryptorFactory().setProvider(provider);
        }
        return new JcaCFBSecretKeyEncryptorFactory().setProvider(provider);
    }
}

