/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ComponentResolvers;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ErrorHandlingArtifactResolver;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.VirtualComponentMetadataResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ComponentResolveMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.ArtifactSelector;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DefaultArtifactSelector;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;
import org.gradle.internal.resolve.resolver.OriginArtifactSelector;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.BuildableComponentResolveResult;

public class ComponentResolversChain {
    private final DependencyToComponentIdResolverChain dependencyToComponentIdResolver;
    private final ComponentMetaDataResolverChain componentMetaDataResolver;
    private final ArtifactResolver artifactResolverChain;
    private final DefaultArtifactSelector artifactSelector;

    public ComponentResolversChain(List<ComponentResolvers> providers, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ResolvedVariantCache resolvedVariantCache) {
        ArrayList<DependencyToComponentIdResolver> depToComponentIdResolvers = new ArrayList<DependencyToComponentIdResolver>(providers.size());
        ArrayList<ComponentMetaDataResolver> componentMetaDataResolvers = new ArrayList<ComponentMetaDataResolver>(1 + providers.size());
        componentMetaDataResolvers.add(VirtualComponentMetadataResolver.INSTANCE);
        ArrayList<ArtifactResolver> artifactResolvers = new ArrayList<ArtifactResolver>(providers.size());
        ArrayList<OriginArtifactSelector> artifactSelectors = new ArrayList<OriginArtifactSelector>(providers.size());
        for (ComponentResolvers provider : providers) {
            depToComponentIdResolvers.add(provider.getComponentIdResolver());
            componentMetaDataResolvers.add(provider.getComponentResolver());
            OriginArtifactSelector artifactSelector = provider.getArtifactSelector();
            if (artifactSelector != null) {
                artifactSelectors.add(artifactSelector);
            }
            artifactResolvers.add(provider.getArtifactResolver());
        }
        this.dependencyToComponentIdResolver = new DependencyToComponentIdResolverChain(depToComponentIdResolvers);
        this.componentMetaDataResolver = new ComponentMetaDataResolverChain(componentMetaDataResolvers);
        this.artifactResolverChain = new ErrorHandlingArtifactResolver(new ArtifactResolverChain(artifactResolvers));
        this.artifactSelector = new DefaultArtifactSelector(artifactSelectors, this.artifactResolverChain, artifactTypeRegistry, calculatedValueContainerFactory, resolvedVariantCache);
    }

    public ArtifactSelector getArtifactSelector() {
        return this.artifactSelector;
    }

    public DependencyToComponentIdResolver getComponentIdResolver() {
        return this.dependencyToComponentIdResolver;
    }

    public ComponentMetaDataResolver getComponentResolver() {
        return this.componentMetaDataResolver;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolverChain;
    }

    private static class DependencyToComponentIdResolverChain
    implements DependencyToComponentIdResolver {
        private final DependencyToComponentIdResolver[] resolvers;

        public DependencyToComponentIdResolverChain(List<DependencyToComponentIdResolver> resolvers) {
            this.resolvers = resolvers.toArray(new DependencyToComponentIdResolver[0]);
        }

        @Override
        public void resolve(DependencyMetadata dependency, VersionSelector acceptor, @Nullable VersionSelector rejector, BuildableComponentIdResolveResult result) {
            for (DependencyToComponentIdResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolve(dependency, acceptor, rejector, result);
            }
        }
    }

    private static class ArtifactResolverChain
    implements ArtifactResolver {
        private final List<ArtifactResolver> resolvers;

        private ArtifactResolverChain(List<ArtifactResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolveArtifact(ModuleVersionIdentifier ownerId, ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactResolveResult result) {
            for (ArtifactResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolveArtifact(ownerId, artifact, moduleSources, result);
            }
        }

        @Override
        public void resolveArtifactsWithType(ComponentResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            for (ArtifactResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolveArtifactsWithType(component, artifactType, result);
            }
        }
    }

    private static class ComponentMetaDataResolverChain
    implements ComponentMetaDataResolver {
        private final List<ComponentMetaDataResolver> resolvers;

        public ComponentMetaDataResolverChain(List<ComponentMetaDataResolver> resolvers) {
            this.resolvers = resolvers;
        }

        @Override
        public void resolve(ComponentIdentifier identifier, ComponentOverrideMetadata componentOverrideMetadata, BuildableComponentResolveResult result) {
            for (ComponentMetaDataResolver resolver : this.resolvers) {
                if (result.hasResult()) {
                    return;
                }
                resolver.resolve(identifier, componentOverrideMetadata, result);
            }
        }

        @Override
        public boolean isFetchingMetadataCheap(ComponentIdentifier identifier) {
            for (ComponentMetaDataResolver resolver : this.resolvers) {
                if (resolver.isFetchingMetadataCheap(identifier)) continue;
                return false;
            }
            return true;
        }
    }
}

